﻿using System;
using System.IO;
using System.Net.Http.Formatting;
using System.Net.Http.Headers;
using System.ServiceModel.Syndication;
using System.Threading.Tasks;
using System.Xml;

namespace WebApi_CustomMediaTypeFormatter
{
    public class UriBasedRssAtomMediaTypeFormatter : MediaTypeFormatter
    {
        private readonly string atom = "application/atom+xml";
        private readonly string rss = "application/rss+xml";

        public UriBasedRssAtomMediaTypeFormatter()
        {
            SupportedMediaTypes.Add(new MediaTypeHeaderValue(atom));
            SupportedMediaTypes.Add(new MediaTypeHeaderValue(rss));
        }

        public override bool CanReadType(Type type)
        {
            return false;
        }

        public override bool CanWriteType(Type type)
        {
            return type == typeof(Uri);
        }

        public override Task WriteToStreamAsync(Type type, object value, Stream writeStream, System.Net.Http.HttpContent content, System.Net.TransportContext transportContext)
        {
            return Task.Factory.StartNew(() =>
            {
                if (type == typeof(Uri))
                    BuildSyndicationFeed(value, writeStream, content.Headers.ContentType.MediaType);
            });
        }

        private void BuildSyndicationFeed(object uri, Stream stream, string contenttype)
        {
            var url = (uri as Uri).OriginalString;

            SyndicationFeedFormatter formatter;            
            XmlTextReader reader = new XmlTextReader(url);
            SyndicationFeed feed = SyndicationFeed.Load(reader);

            if (contenttype == "application/atom+xml")
            {
                formatter = new Atom10FeedFormatter(feed);
            }
            else
            {
                formatter = new Rss20FeedFormatter(feed);
            }

            using (var writer = XmlWriter.Create(stream))
            {
                formatter.WriteTo(writer);
                writer.Flush();
                writer.Close();
            }
        }
    }
}
