﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Web.Http;
using System.Web.Http.Dispatcher;
using System.Web.Http.SelfHost;

namespace WebApi_CustomMediaTypeFormatter
{
    class Program
    {
        static void Main(string[] args)
        {
            var config = new HttpSelfHostConfiguration("http://localhost:8081");
      
            config.Routes.MapHttpRoute(
                "API Default", "api/{controller}/{id}",
                new { id = RouteParameter.Optional });

            config.Services.Replace(typeof(IAssembliesResolver), new CustomAssembliesResolver());

            config.Formatters.Add(new UriBasedRssAtomMediaTypeFormatter());
            config.Formatters.Add(new CustomSyndicationFeedFormatter());

            using (HttpSelfHostServer server = new HttpSelfHostServer(config))
            {
                server.OpenAsync().Wait();

                Console.WriteLine("Listening for HTTP requests.");
                Console.WriteLine("(Run the ClientApp project to send requests).");
                Console.WriteLine();
                Console.WriteLine("Press Enter to quit.");
                Console.ReadLine();
            }
        }
    }
}
