﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Http;

namespace WebApi_CustomMediaTypeFormatter
{
    public class FeedsController: ApiController
    {
        Dictionary<string, Uri> feedsDictionary = new Dictionary<string, Uri>();

        public FeedsController()
        {
            feedsDictionary.Add("codeproject", new Uri("http://www.codeproject.com/webservices/articlerss.aspx"));
        }

        public Uri GetFeeds(string name)
        {
            var feed = feedsDictionary.SingleOrDefault(f => f.Key == name).Value;
            if (feed == null)
            {
                throw new Exception("There are no feeds associated with the name: " + name);
            }
            else
                return feed as Uri;
        }
    }
}
