﻿using ProductsLibrary.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Web.Http;

namespace WebApiLibrary
{
    public class ProductsController : ApiController
    {
        Product[] products = new Product[]  
        {  
            new Product { Id = 1, Name = "Tomato Soup", Category = "Groceries", Price = 1, Description="Product of Waukegan, USA" },  
            new Product { Id = 2, Name = "Yo-yo", Category = "Toys", Price = 3.75M, Description="Product of Gurnee Mills, IL" },  
            new Product { Id = 3, Name = "Hammer", Category = "Hardware", Price = 16.99M , Description="Product of Bangalore, India"}  
        };

        public IEnumerable<FeedItem> GetAllProductsFeed()
        {
            List<FeedItem> feedItems = new List<FeedItem>();
            foreach (var product in products)
            {
                feedItems.Add(new FeedItem
                {
                    CreatedAt = DateTime.Now,
                    CreatedBy= "Ranjan",
                    Title = product.Name,
                    Description = product.Description,
                    Category = product.Category 
                });
            }
            return feedItems;
        }

        public Product GetProductById(int id)
        {
            var product = products.FirstOrDefault((p) => p.Id == id);
            if (product == null)
            {
                throw new HttpResponseException(HttpStatusCode.NotFound);
            }
            return product;
        }

        public IEnumerable<Product> GetProductsByCategory(string category)
        {
            return products.Where(p => string.Equals(p.Category, category,
                    StringComparison.OrdinalIgnoreCase));
        }
    }
}
