﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

namespace Client
{
    class Program
    {
        static HttpClient client = new HttpClient();

        static void Main(string[] args)
        {
            client.BaseAddress = new Uri("http://localhost:8081");
            Console.WriteLine("Press Enter to quit.");

            Console.WriteLine("*************************************** Begin: Requesting CodeProject Feeds ***************************************");
            GetFeeds("codeproject");
            Console.WriteLine("*************************************** End Of CodeProject Feeds ***************************************");
            Console.WriteLine("*************************************** Begin: Get All Product Feeds ***************************************");
            GetAllProductsFeeds();
            Console.WriteLine("*************************************** End of Get All Product Feeds ***************************************");
            Console.ReadLine();
        }

        private static void GetFeeds(string name)
        {
            try
            {
                string query = string.Format("api/feeds?name={0}", name);
                client.DefaultRequestHeaders.Accept.Add(new System.Net.Http.Headers.MediaTypeWithQualityHeaderValue("application/rss+xml"));

                var resp = client.GetAsync(query).Result;
                resp.EnsureSuccessStatusCode();

                var feeds = resp.Content.ReadAsStringAsync().Result;
                Console.WriteLine(feeds);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        private static void GetAllProductsFeeds()
        {
            try
            {
                string query = string.Format("api/products");
                client.DefaultRequestHeaders.Accept.Add(new System.Net.Http.Headers.MediaTypeWithQualityHeaderValue("application/rss+xml"));

                var resp = client.GetAsync(query).Result;
                resp.EnsureSuccessStatusCode();

                var feeds = resp.Content.ReadAsStringAsync().Result;
                Console.WriteLine(feeds);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
    }
}
