﻿using System;
using System.IO;
using System.IO.Compression;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Web.Http;
using System.Web.Http.Dispatcher;
using System.Web.Http.SelfHost;
using WebApiManageContactsUnitTest;

namespace WebApi_CustomDelegatingHandler
{
    class Program
    {
        static void Main(string[] args)
        {
            Uri _baseAddress = new Uri("http://localhost:8081/");

            // Get the executable assembly location
            var assembly = System.Reflection.Assembly.GetExecutingAssembly().Location;

            // The Assembly to load
            string path = assembly.Substring(0, assembly.LastIndexOf("\\")) + "\\ProductsLibrary.dll";

            HttpSelfHostConfiguration config = new HttpSelfHostConfiguration(_baseAddress);
            config.MessageHandlers.Add(new TraceMessageHandler());
            config.MessageHandlers.Add(new CompressionDelegateHandler());
         
            config.Services.Replace(typeof(IAssembliesResolver), new CustomAssemblyResolver(path));
            config.Routes.MapHttpRoute(
                name: "DefaultApi",
                routeTemplate: "api/{controller}/{id}",
                defaults: new { id = RouteParameter.Optional }
            );

            HttpSelfHostServer server = null;
            // Create server
            server = new HttpSelfHostServer(config);
            Console.WriteLine("Waiting for clients");
            // Start listening
            server.OpenAsync().Wait();

            TraceRequest();
            SendRequest();

            Console.ReadLine();          
        }

        static byte[] Decompress(byte[] gzip)
        {
            using (GZipStream stream = new GZipStream(new MemoryStream(gzip),
                                  CompressionMode.Decompress))
            {
                const int size = 4096;
                byte[] buffer = new byte[size];
                using (MemoryStream memory = new MemoryStream())
                {
                    int count = 0;
                    do
                    {
                        count = stream.Read(buffer, 0, size);
                        if (count > 0)
                        {
                            memory.Write(buffer, 0, count);
                        }
                    }
                    while (count > 0);
                    return memory.ToArray();
                }
            }
        }

        private async static void TraceRequest()
        {
            try
            {
                HttpClient client = new HttpClient();
                client.BaseAddress = new Uri("http://localhost:8081/");
        
                HttpRequestMessage request = new HttpRequestMessage()
                {
                    RequestUri = new Uri("http://localhost:8081/api/Products"),
                    Method = HttpMethod.Trace
                };

                Console.WriteLine("********* Send Request to get all products *******");

                HttpResponseMessage httpReponse = client.SendAsync(request).Result;
                var text = await httpReponse.Content.ReadAsStringAsync();
                Console.WriteLine(text);
                Console.WriteLine("\n");
            }
            catch (HttpRequestException e)
            {
                Console.WriteLine("\nException Caught!");
                Console.WriteLine("Message :{0} ", e.Message);
            }
        }
        
        private async static void SendRequest()
        {
            try
            {
                HttpClient client = new HttpClient();
                client.BaseAddress = new Uri("http://localhost:8081/");
                client.DefaultRequestHeaders.Clear();
                client.DefaultRequestHeaders.AcceptEncoding.Add(new StringWithQualityHeaderValue("gzip"));

                HttpRequestMessage request = new HttpRequestMessage()
                {
                    RequestUri = new Uri("http://localhost:8081/api/Products"),
                    Method = HttpMethod.Get
                };

                Console.WriteLine("********* Send Request to get all products *******");
             
                HttpResponseMessage response = client.SendAsync(request).Result;
                var compressedResponseInBytes = await response.Content.ReadAsByteArrayAsync();
                var decompressedResponseInBytes = Decompress(compressedResponseInBytes);

                string text = System.Text.ASCIIEncoding.ASCII.GetString(decompressedResponseInBytes);
                Console.WriteLine(text);                
                Console.WriteLine("\n");
            }
            catch (HttpRequestException e)
            {
                Console.WriteLine("\nException Caught!");
                Console.WriteLine("Message :{0} ", e.Message);
            }
        }
    }
}
