using System;
using System.Data;

public partial class Demo : System.Web.UI.MasterPage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Repeater1.DataBind();
        }
    }

    protected DataTable ItemList
    {
        get
        {
            DataSet ds = new DataSet();
            ds.ReadXml(Server.MapPath("navigation.config"));
            DataTable dt = ds.Tables["Item"];

            foreach (DataRow r in dt.Rows)
            {
                string url = r["url"] as string;

                if (url == null)
                    continue;

                if (Request.Path.ToUpper().IndexOf("/" + url.ToUpper()) != -1)
                {
                    r["url"] = ResolveUrl(url);
                    r["class"] = "MenuSelected";
                }
                else
                {
                    r["url"] = ResolveUrl(url);
                    r["class"] = "MenuLink";
                }

            }

            return dt;
            /*
            DataSet ds = new DataSet();
            ds.ReadXml(Server.MapPath("navigation.config"));
            DataTable dt = ds.Tables["Item"];

            foreach (DataRow r in dt.Rows)
            {
                string url = r["url"] as string;

                if (url == null)
                    continue;

                if (url == SelectedPage)
                {
                    r["url"] = Request.Url.ToString(); 
                    r["class"] = "MenuSelected";
                }
                else
                {
                    r["url"] = url;
                    r["class"] = "MenuLink";
                }

            }

            return dt;
            */
        }
    }

    private string SelectedPage
    {
        get
        {
            return Request.Path.Substring(Request.Path.LastIndexOf("/") + 1);
        }
    }
}
