Imports System
Imports System.Collections.Generic
Imports System.Data
Imports System.Text
Imports System.Web.UI
Imports DayPilot.Web.Ui
Imports DayPilot.Web.Ui.Data
Imports DayPilot.Web.Ui.Events
Imports DayPilot.Web.Ui.Events.Scheduler

Partial Public Class Project_Default
	Inherits Page

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		If Not IsPostBack Then
			DayPilotScheduler1.Days = Date.DaysInMonth(2013, 2)
			DayPilotScheduler1.StartDate = New Date(2013, 02, 01)
			LoadEvents()
		End If

		Dim cols As String = (New DataManager()).GetUserConfig(User.Identity.Name, "project.cols")
		If cols IsNot Nothing Then
			DayPilotScheduler1.RowHeaderColumnWidths = cols
		End If

	End Sub

	Private Function TaskLink(ByVal name As String, ByVal id As Integer) As String
		Dim sb As New StringBuilder()
		sb.Append("<div style=' padding: 0px 2px 0px 2px'>")
		sb.Append("<div class='task_status ")
		sb.Append("' data-taskid='" & id & "'></div>")

		sb.Append("<a title='")
		sb.Append(name)
		sb.Append("' ")
		sb.Append("href='javascript:edit(""")
		sb.Append(id)
		sb.Append(""")'>")
		sb.Append(name)
		sb.Append("</a>")
		sb.Append("</div>")

		Return sb.ToString()
	End Function

	Protected Sub UpdatePanelScheduler_Load(ByVal sender As Object, ByVal e As EventArgs)
	End Sub

	Protected Sub DayPilotScheduler1_BeforeEventRender(ByVal sender As Object, ByVal e As BeforeEventRenderEventArgs)
'        
'        Task t = (Task)e.DataItem.Source;
'        e.DurationBarColor = Helper.StatusToColor(t["AssignmentStatus"]);
'         * 
	End Sub


	Protected Sub DayPilotScheduler1_HeaderColumnWidthChanged(ByVal sender As Object, ByVal e As HeaderColumnWidthChangedEventArgs)
		CType(New DataManager(), DataManager).SetUserConfig(User.Identity.Name, "project.cols", DayPilotScheduler1.RowHeaderColumnWidths)
		LoadEvents()
	End Sub

	Protected Sub RadioButtonListZoom_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs)
		LoadEvents()
	End Sub


	Private Sub LoadEvents()
		DayPilotScheduler1.DataStartField = "AssignmentStart"
		DayPilotScheduler1.DataEndField = "AssignmentEnd"
		DayPilotScheduler1.DataTextField = "AssignmentNote"
		DayPilotScheduler1.DataValueField = "AssignmentId"

		DayPilotScheduler1.DataSource = (New DataManager()).GetAssignments()
		DataBind()
	End Sub

	Protected Sub ButtonRefresh_Click(ByVal sender As Object, ByVal e As EventArgs)
		LoadEvents()
	End Sub

	Protected Sub DayPilotScheduler1_BeforeResHeaderRender(ByVal sender As Object, ByVal e As BeforeHeaderRenderEventArgs)
		Dim task As DataItemWrapper = e.DataItem

		Dim name As String = CStr(task("AssignmentNote"))
		Dim id As Integer = Convert.ToInt32(task("AssignmentId"))

		'TimeSpan duration = TimeSpan.FromDays(Convert.ToInt32(task["AssignmentDuration"]));
		Dim duration As Integer = Convert.ToInt32(task("AssignmentDuration"))

		e.InnerHTML = TaskLink(name, id)
		e.Columns(0).InnerHTML = "<div style='text-align:right; padding: 0px 6px 0px 2px;'>" & duration & " days</div>"

	End Sub
End Class