<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Connector Example</title>
</head>

<body>
<h1>Example to Explain Connector Class</h1>
<h2>Connector Class can be used to dynamically bind parameters to SQL statements and to its results</h2>
<h4 style="color:red;">Make Sure to change the connection settings on line 31 of connector.php</h4>
<pre><strong>SQL to Create Test_Table</strong>
CREATE TABLE IF NOT EXISTS `test_table` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
</pre>
<form name="testform" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
	<fieldset><legend>Query(ies)</legend>
        <input type="submit" name="full_list" value="Show Full List" /> (or)
        <label for="textbox">Punch-In an ID to Filter</label>
        <input type="text" name="textbox" />
        <input type="submit" name="filter" value="Filter" />
    </fieldset>
    <fieldset>
    	<legend>Insert a Record</legend>
        <label>USER ID is Auto Incremental. Type Name Here</label>
        <input type="text" name="cust_name" />
        <input type="submit" name="addvalue" value="Add Item" />
    </fieldset>
    <fieldset>
    	<legend>Update a Record</legend>
        <label>Type in the ID</label>
        <input type="text" name="cust_ID" />
        <label>Type in New Name (to be changed to)</label>
        <input type="text" name="cust_new_name" />
        <input type="submit" name="updatevalue" value="Update Item" />
    </fieldset>
    <fieldset>
    	<legend>Delete a Record</legend>
        <label>Type in the ID</label>
        <input type="text" name="cust_ID_to_del" />
        <input type="submit" name="deletevalue" value="Delete Item" />
    </fieldset>
</form>
<?php
//    SQL DEFINITIONS //
define("SIMPLE_QUERY","select * from test_table",true);
define("PREPARED_QUERY","select * from test_table where id = ?",true);
define("INSERT_STATEMENT","INSERT INTO test_table values (?,?)",true);
define("DELETE_STATEMENT","DELETE from test_table where id = ?",true);
define("UPDATE_STATEMENT","UPDATE test_table set name = ? where id = ?",true);
$result_status = array('Failed','Success');
// END OF SQL DEFINITIONS //

include 'connector.php'; // INCLUDES THE CONNECTOR.PHP FILE USING __autoload


// example for simple query
echo '<fieldset><legend>Result</legend>';
if(isset($_POST['full_list']))
{	
	$temp = new connector(); // introduce connector	
	$query = SIMPLE_QUERY; // see definition.php for SQLs
	$temp->sql = $query;
	$result = $temp->query(); 
	print_r($result);
}	

// example for prepared query
	
if(isset($_POST['filter']))
{
	$temp = new connector(); // introduce connector	
	$query = PREPARED_QUERY;
	$temp->sql = $query;
	$temp->types = array('s');
	$temp->values = array($_POST['textbox']);
	$result = $temp->query();
	if(count($result) > 0) {
		print_r($result);	
	} else {
		echo '<span style="color:red;">Sorry!, that was an invalid ID</span>';
	}
}	
	
// example to insert records to a table 
if(isset($_POST['addvalue']))
{	
	$temp = new connector(); // introduce connector	
	$query = INSERT_STATEMENT; 
	$temp->sql = $query;
	$temp->types = array('i','s');
	$temp->values = array('',$_POST['cust_name']); // first field being auto_incremental
	$result = $temp->perform(); // perform() function can be used to insert/delete or update data
	echo "Insert Record Status : $result_status[$result]";
}	

if(isset($_POST['updatevalue']))
{	
	$temp = new connector(); // introduce connector	
	$query = UPDATE_STATEMENT; 
	$temp->sql = $query;
	$temp->types = array('s','i');
	$temp->values = array($_POST['cust_new_name'],$_POST['cust_ID']); // first field being auto_incremental
	$result = $temp->perform(); // perform() function can be used to insert/delete or update data
	echo "Update Record Status : $result_status[$result]";
}	
if(isset($_POST['deletevalue']))
{	
	$temp = new connector(); // introduce connector	
	$query = DELETE_STATEMENT; 
	$temp->sql = $query;
	$temp->types = array('i');
	$temp->values = array($_POST['cust_ID_to_del']); // first field being auto_incremental
	$result = $temp->perform(); // perform() function can be used to insert/delete or update data
	echo "Delete Record Status : $result_status[$result]";
}	
echo '</fieldset>';
?>
</body>
</html>
