<?php

// the word simple, wherever used in this document refers that no parameters (criteria) are provided to the query //

// Developed by     :   S. Muralikrishna
// Email            :   muralikrishna.srinivasan@gmail.com
// Class            :   connector
// Description      :   Class to connect to mysql server and execute simple and prepared queries by dynamically
//                      Binding parameters and fetch / return result in the form of a nulti-dimentional array

// Usage            :   Insert statement example
//
//  $qry = "insert into test_table values (?,?)";
//  $test = new connector();
//  $test->sql = $qry;
//  $test->types = array('i','s') // an integer and a strign type
//  $test->values = array('',$value1) // first value is left blank as it is assumed to be an auto-incremental field
//  $test->perform();
//  
//  See the definitions.php and test_form_with_connector.php for more detailed example

class connector
{
	var $sql,$types,$values,$mysqli;
	private $_bindVarsArray = array();
    private $_results = array();

	function __construct() // get the sql from the user
	{
		error_reporting(E_ALL ^ E_NOTICE);
		$this->mysqli = new mysqli($lostname,$username,$password,$database); //credentials passed to connect to mysql
		if(mysqli_connect_error())
		{
			echo "CONNECTOR CLASS ERROR : Unable to connect to mysql server. Change the connection settings and try again"; die;
		}
	}
	
	public function perform()// general for all activities e.g. insert, update, delete and NOT for select
	{
		if($this->sql == "") { echo "Sorry! you have not provided an SQL statement"; die; }
		$stmt = $this->mysqli->prepare($this->sql);
		$sp = new class_binder();
		for($i=0;$i<=(count($this->types)-1);$i++)
		{
			$sp->Add_Parameter($i, $this->types[$i]);
		}
		$sp->Bind_Params($stmt);

		for($i=0;$i<=(count($this->values)-1);$i++)
		{
			$sp->Set_Parameter($i,$this->values[$i]);
		}

		$stmt->execute();
		$result =  $stmt->affected_rows;
		$stmt->close();
		$this->mysqli->close();
		return $result;	
	}
		
	public function query() // should be used only for select statement (both simple and prepared)
	{
		if($this->sql == "") { echo "Sorry! you have not provided an SQL statement"; die; }
		if(strpos($this->sql,"?") === false) // identify whether the SQL provided is a prepared query or a simple query
		{
			$result_array = $this->simplequery();
		} else {
			$result_array = $this->preparequery();
		}
		return $result_array;
	}
	
	public function simplequery() // function to execute simple query
	{
		$result_array = array();
		$result = $this->mysqli->query($this->sql);
		if($result->num_rows > 0) {
		$row = 0; $cols = 0; $fields = $result->field_count; --$fields;
		while($data = $result->fetch_row())
		{
			for($counter = 0; $counter <= $fields; $counter++)
			{
				$result_array[$row][$counter] = $data[$counter];		
			}
			$row++;
		}
		$this->mysqli->close();
		return $result_array;
		} else {
			return false;
		}
	}
	public function preparequery()
	{
		$stmt = $this->mysqli->prepare($this->sql);
		$sp = new class_binder();
		for($i=0;$i<=(count($this->types)-1);$i++)
		{
			$sp->Add_Parameter($i, $this->types[$i]);
		}
		$sp->Bind_Params($stmt);

		for($i=0;$i<=(count($this->types)-1);$i++)
		{
			$sp->Set_Parameter($i,$this->values[$i]);
		}		
		$stmt->execute();
		$stmt->store_result();
		$meta = $stmt->result_metadata();
		$results = array();
		$i = 0;
		while ($column = $meta->fetch_field()) {
			$fieldname[] = $column->name;
			$bindVarsArray[] = &$results[$column->name];
		}    
		call_user_func_array(array($stmt, 'bind_result'), $bindVarsArray); // bind results dynamically
		$_array = array();
		$i= 0;
		while($stmt->fetch()) 
		{
			for($z=0;$z<=(count($fieldname)-1);$z++) {
				$_array[$i][$z]= $results[$fieldname[$z]];
			}
			$i++;
		}
		$stmt->close();
		$this->mysqli->close();
		return $_array;
	}
}
class class_binder // class to bind values to types
{
    private $_array = array();
   
    public function Add_Parameter($name, $type, $value = NULL)
    {
        $this->_array[$name] = array("type" => $type, "value" => $value);
    }
   
    public function Get_Type_String()
    {
        $types = "";   
   
        foreach($this->_array as $name => $la)
            $types .= $la['type'];
       
        return $types;
    }
   
    public function Set_Parameter($name, $value)
    {
        if (isset($this->_array[$name]))
        {
            $this->_array[$name]["value"] = $value;
            return true;
        }
        return false;
    }
   
    public function Bind_Params(&$stmt)
    {
        $ar = Array();
       
        $ar[] = $this->Get_Type_String();
       
        foreach($this->_array as $name => $la)
            $ar[] = &$this->_array[$name]['value'];
       
        return call_user_func_array(array($stmt, 'bind_param'),$ar);
    }
}
?>