﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true"
    CodeBehind="ContactListPage.aspx.cs" Inherits="Ra.GridView.Web.ContactListPage" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="asp" %>
<asp:Content ID="_headContent" ContentPlaceHolderID="HeadContent" runat="server">
    <script language="javascript" type="text/javascript">

        function ShowEntityEditor(entityID) {
            var frame = $get('_editIframe');
            frame.src = "ContactPage.aspx?ID=" + entityID;
            $find('EditModalPopup').show();
            return false;
        }

        function EditOkScript() {
            var button = $get('_refreshGridPopupButton');
            button.click();
        }

        function EditCancelScript() {
            var frame = $get('_editIframe');
            frame.src = "ContactPage.aspx";
            return false;
        }
        
    </script>
</asp:Content>
<asp:Content ID="_filterContent" ContentPlaceHolderID="UpperContent" runat="server">
    <table border="0">
        <tr>
            <td style="padding-left: 250px;">
                <asp:Label runat="server" ID="_groupLabel" Text="Group"></asp:Label>
            </td>
            <td style="padding-left: 10px;">
                <asp:DropDownList runat="server" ID="_groupDropDownList" EnableViewState="true">
                </asp:DropDownList>
            </td>
            <td style="padding-left: 20px;">
                <asp:Button ID="_applyFilterButton" runat="server" OnClick="_applyFilterButton_Click"
                    Text="Apply Filter" />
            </td>
            <td>
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="_mainContent" ContentPlaceHolderID="MainContent" runat="server">
    <div style="padding-top: 12px; display: block;">
        <asp:ObjectDataSource ID="_gridObjectDataSource" runat="server" EnablePaging="true"
            TypeName="Ra.GridView.Web.Data.ContactListPageData" SelectMethod="GetDataByFilter"
            StartRowIndexParameterName="startIndex" MaximumRowsParameterName="pageSize" SortParameterName="sortBy"
            SelectCountMethod="GetCount" />
        <asp:GridView ID="_contactsGridView" runat="server" AutoGenerateColumns="False" DataKeyNames="ID"
            EmptyDataText="There are no data for the current filter!" AllowSorting="True"
            OnRowCommand="_contactsGridView_RowCommand" ViewStateMode="Enabled" CellPadding="4"
            GridLines="Both" Width="100%" ForeColor="#333333" AllowPaging="true" PageSize="<%$appSettings:GridPageSize %>"
            PagerSettings-Mode="NumericFirstLast" DataSourceID="_gridObjectDataSource" OnRowDataBound="_contactsGridView_RowDataBound">
            <AlternatingRowStyle BackColor="White" ForeColor="#284775" />
            <Columns>
                <asp:TemplateField HeaderText="Operations" SortExpression="c.ID">
                    <ItemTemplate>
                        <asp:ImageButton ID="_addNewLinkButton" runat="server" ToolTip="New Contact" ImageUrl="~/Images/Add.gif">
                        </asp:ImageButton>
                        <asp:ImageButton runat="server" ID="_editLinkButton" ImageUrl="~/Images/Edit.gif"
                            ToolTip="Edit"></asp:ImageButton>
                        <asp:ImageButton runat="server" ID="_deleteLinkButton" ImageUrl="~/Images/Delete.gif"
                            ToolTip="Delete" CommandName="DeleteContact" CommandArgument='<%# Eval("ID") %>'
                            message="Are you shore that you want to delete the current contact?" OnClientClick='return confirm(this.getAttribute("message"))'>
                        </asp:ImageButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Person" HeaderText="Name" SortExpression="c.FirstName, c.LastName" />
                <asp:BoundField DataField="Group" HeaderText="Group" SortExpression="g.Name" />
                <asp:BoundField DataField="Phone" HeaderText="Phone" SortExpression="c.Phone" />
                <asp:TemplateField HeaderText="Email" SortExpression="c.Email">
                    <ItemTemplate>
                        <asp:HyperLink runat="server" ID="_emailTo" Text='<%# Eval("Email") %>' NavigateUrl='<%# Eval("Email", "mailto:{0}") %>' />
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
            <EditRowStyle BackColor="#999999" />
            <FooterStyle BackColor="#5D7B9D" ForeColor="White" Font-Bold="True" />
            <HeaderStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
            <PagerStyle BackColor="#5D7B9D" ForeColor="White" HorizontalAlign="Center" />
            <RowStyle BackColor="#F7F6F3" HorizontalAlign="Center" ForeColor="#333333" />
            <SelectedRowStyle BackColor="#E2DED6" Font-Bold="True" ForeColor="#333333" />
            <SortedAscendingCellStyle BackColor="#E9E7E2" />
            <SortedAscendingHeaderStyle BackColor="#506C8C" />
            <SortedDescendingCellStyle BackColor="#FFFDF8" />
            <SortedDescendingHeaderStyle BackColor="#6F8DAE" />
        </asp:GridView>
    </div>
    <%------
     ------- Begin the HTML code for Edit Entity by using ModalPopupExtemder and IFRAME.
     -------%>
    <asp:Button ID="_editPopupButton" runat="server" Text="Edit Contact" Style="display: none" />
    <asp:ModalPopupExtender ID="_modalPopupExtender" runat="server" BackgroundCssClass="modalPopupBackground"
        TargetControlID="_editPopupButton" PopupControlID="_editWindowDiv" OkControlID="_okPopupButton"
        OnOkScript="EditOkScript();" CancelControlID="_cancelPopupButton" OnCancelScript="EditCancelScript();"
        BehaviorID="EditModalPopup">
    </asp:ModalPopupExtender>
    <div class="_popupButtons" style="display: none">
        <input id="_okPopupButton" value="OK" type="button" />
        <input id="_cancelPopupButton" value="Cancel" type="button" />
        <asp:Button ID="_refreshGridPopupButton" runat="server" Text="Refresh" ClientIDMode="Static"
            OnClick="_refreshGridPopupButton_Click" />
    </div>
    <div id="_editWindowDiv" style="display: none;">
        <iframe id="_editIframe" class="contactPageFrame" frameborder="0"></iframe>
    </div>
    <%------ End the HTML code for Edit Entity by using ModalPopupExtemder and IFRAME. -------%>
</asp:Content>
