﻿#region Copyright (c) 2010 Raul Iloc
/*
{***************************************************************************}
{                                                                           }
{       Copyright (c) 2010  RAUL ILOC (rauliloc@yahoo.com)                  }
{       ALL RIGHTS RESERVED                                                 }
{                                                                           }
{   THE WORK IS PROVIDED UNDER THE TERMS OF THIS CODE PROJECT OPEN LICENSE. }
{   THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW.         }
{   ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE         }
{   OR COPYRIGHT LAW IS PROHIBITED.                                         }
{                                                                           }
{                                                                           }
{  BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HEREIN, YOU ACCEPT AND     }
{  AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. THE AUTHOR GRANTS YOU    }
{  THE RIGHTS CONTAINED HEREIN IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH  }
{  TERMS AND CONDITIONS. IF YOU DO NOT AGREE TO ACCEPT AND BE BOUND BY THE  }
{  TERMS OF THIS LICENSE, YOU CANNOT MAKE ANY USE OF THE WORK.              }
{                                                                           }
{***************************************************************************}
*/
#endregion Copyright (c) 2010 Raul Iloc

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.Objects;
using System.IO;
using System.Web.UI;
using System.Data;
//
using Ra.GridView.Data;
using Ra.GridView.Util;


namespace Ra.GridView.Web
{
    /// <summary>
    /// Defines the base class for all pages.
    /// </summary>
    public abstract class BasePage : System.Web.UI.Page
    {
        /// <summary>
        /// The data context.
        /// </summary>
        private RaGridViewEntities _dataContext;
        /// <summary>
        /// Gets the data context.
        /// </summary>
        public RaGridViewEntities DataContext
        {
            get
            {
                return _dataContext;
            }
        }
        /// <summary>
        /// Gets or sets the error message that will be shown.
        /// </summary>
        public abstract string ErrorMessage
        {
            get;
            set;
        }
        
        /// <summary>
        /// Initializes a new instance of the BasePage page.
        /// </summary>
        public BasePage()
        {

        }

        /// <summary>
        /// Raises PreInit event used to create the data context.
        /// </summary>
        /// <param name="e">The event argument.</param>
        protected override void OnPreInit(EventArgs e)
        {
            _dataContext = new RaGridViewEntities();
            //
            base.OnPreInit(e);
        }

        /// <summary>
        /// Raises Unload event used to dispoze the data context.
        /// </summary>
        /// <param name="e">The event argument.</param>
        protected override void OnUnload(EventArgs e)
        {
            if (_dataContext != null)
            {
                _dataContext.Dispose();
                _dataContext = null;
            }
            //
            base.OnUnload(e);
        }
    }
}