﻿#region Copyright (c) 2010 Raul Iloc
/*
{***************************************************************************}
{                                                                           }
{       Copyright (c) 2010  RAUL ILOC (rauliloc@yahoo.com)                  }
{       ALL RIGHTS RESERVED                                                 }
{                                                                           }
{   THE WORK IS PROVIDED UNDER THE TERMS OF THIS CODE PROJECT OPEN LICENSE. }
{   THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW.         }
{   ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE         }
{   OR COPYRIGHT LAW IS PROHIBITED.                                         }
{                                                                           }
{                                                                           }
{  BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HEREIN, YOU ACCEPT AND     }
{  AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. THE AUTHOR GRANTS YOU    }
{  THE RIGHTS CONTAINED HEREIN IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH  }
{  TERMS AND CONDITIONS. IF YOU DO NOT AGREE TO ACCEPT AND BE BOUND BY THE  }
{  TERMS OF THIS LICENSE, YOU CANNOT MAKE ANY USE OF THE WORK.              }
{                                                                           }
{***************************************************************************}
*/
#endregion Copyright (c) 2010 Raul Iloc

using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data.Objects;
using System.IO;
using System.Web.UI;
using System.Data;
//
using Ra.GridView.Data;
using Ra.GridView.Util;


namespace Ra.GridView.Web
{
    /// <summary>
    /// Defines the base class for all pages that display list of entities.
    /// </summary>
    public class BaseListPage: BasePage
    {
        /// <summary>
        /// The master page.
        /// </summary>
        protected SiteMaster _masterPage;
        /// <summary>
        /// Gets or sets the error message.
        /// </summary>
        /// <remarks>
        /// The error message is shown in master page header!
        /// </remarks>
        public override string ErrorMessage
        {
            get { return _masterPage.ErrorMessage; }
            set { _masterPage.ErrorMessage = value; }
        }
        
        /// <summary>
        /// Initializes a new instance of the BaseLitPage page.
        /// </summary>
        public BaseListPage() : base()
        {
            
        }

        /// <summary>
        /// Raises OnInit event used to get the reference to master page.
        /// </summary>
        /// <param name="e">The event argument.</param>
        protected override void OnInit(EventArgs e)
        {
            _masterPage = (SiteMaster)Page.Master;
            //
            base.OnInit(e);
        }
        
    }
}