﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Demo3.aspx.cs" Inherits="Demo3" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Responsive GridView - Advanced Options Demo</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable = no">
    <link href="styles/basic.css" type="text/css" rel="stylesheet" />
    <script src="scripts/jquery-1.9.0.min.js" type="text/javascript"></script>
    <script src="scripts/jquery.responsivetable.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            setupResponsiveTables();
        });

        function setupResponsiveTables() {
            $('.responsiveTable1').responsiveTable({ 
                staticColumns: 2,
                scrollRight: false, 
                scrollHintEnabled: true,
                scrollHintDuration: 3000
            });
        }
    </script>
</head>
<body>
    <h1>Responsive GridView</h1>
    <h2>Advanced Options Demo</h2>
    <p>Some extra options are configured in this demo:</p>
    <ul>
        <li>Two columns are kept in place when the Responsive GridView is triggered</li>
        <li>The scrollable area is configured to scroll to the left instead of the right</li>
        <li>The user hint to scroll the table left and right is displayed for 3 seconds instead of the default 2 seconds</li>
    </ul>
    <form id="form1" runat="server">
        <h3>Task List</h3>
        <asp:GridView ID="GridView1" runat="server" RowStyle-Wrap="false"
            DataSourceID="XmlDataSource1" CssClass="responsiveTable1" 
            AutoGenerateColumns="false">
            <Columns>
                <asp:BoundField DataField="Task" HeaderText="Task" />
                <asp:BoundField DataField="Assigned" HeaderText="Assigned" />
                <asp:BoundField DataField="Due" HeaderText="Due" />
                <asp:BoundField DataField="Completed" HeaderText="Completed" />
                <asp:BoundField DataField="Status" HeaderText="Status" />
            </Columns>
        </asp:GridView>
        <asp:XmlDataSource ID="XmlDataSource1" runat="server" 
            DataFile="~/data/SampleData1.xml"></asp:XmlDataSource>        
        <p>
            <asp:LinkButton ID="LinkButton1" runat="server" Text="Back to Menu" PostBackUrl="~/Default.aspx"></asp:LinkButton>
        </p>
    </form>
</body>
</html>
