﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Demo2.aspx.cs" Inherits="Demo2" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Responsive GridView - UpdatePanel Demo</title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable = no">
    <link href="styles/basic.css" type="text/css" rel="stylesheet" />
    <script src="scripts/jquery-1.9.0.min.js" type="text/javascript"></script>
    <script src="scripts/jquery.responsivetable.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            setupResponsiveTables();
            
            // Register method to fire at the end of an asp:UpdatePanel response
            $(window).on('load', function () {
                Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endUpdatePanelRequest);
            });
        });
        
        function endUpdatePanelRequest() {
            setupResponsiveTables();
        }

        function setupResponsiveTables() {
            if ($('#SetupResponsiveTableOnReload').is(':checked')) {
                $('.responsiveTable1').responsiveTable();
            }
        }
    </script>
</head>
<body>
    <h1>Responsive GridView</h1>
    <h2>UpdatePanel Demo</h2>
    <p>The Responsive Table jQuery Plugin is being called by the ASP.NET AJAX PageRequestManager when the UpdatePanel content is refreshed. Uncheck the checkbox below and click on the Submit button to see the effect of disabling this call.</p>
    <form id="form1" runat="server">
        <h3>Task List</h3>
        <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
        Setup Responsive Table on refresh: <input id="SetupResponsiveTableOnReload" type="checkbox" checked="checked" />
        <br /><i>(The dashed line outlines the UpdatePanel)</i>
        <div class="updatePanel">
            <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                <ContentTemplate>
                    Click the submit button to refresh the UpdatePanel: <asp:Button ID="Button1" runat="server" Text="Submit" Font-Size="Large" Width="6em" />
                    <br /><br />
                    <asp:GridView ID="GridView1" runat="server" RowStyle-Wrap="false"
                        DataSourceID="XmlDataSource1" CssClass="responsiveTable1" 
                        AutoGenerateColumns="false">
                        <Columns>
                            <asp:BoundField DataField="Task" HeaderText="Task" />
                            <asp:BoundField DataField="Assigned" HeaderText="Assigned" />
                            <asp:BoundField DataField="Due" HeaderText="Due" />
                            <asp:BoundField DataField="Completed" HeaderText="Completed" />
                            <asp:BoundField DataField="Status" HeaderText="Status" />
                        </Columns>
                    </asp:GridView>
                    <asp:XmlDataSource ID="XmlDataSource1" runat="server" 
                        DataFile="~/data/SampleData1.xml"></asp:XmlDataSource>                
                </ContentTemplate>
            </asp:UpdatePanel>
        </div>
        <p>
            <asp:LinkButton ID="LinkButton1" runat="server" Text="Back to Menu" PostBackUrl="~/Default.aspx"></asp:LinkButton>
        </p>
    </form>
</body>
</html>
