<?php
/**
 * @author Daniel ABEL
 * @copyright 11/2007
 * @version  1.0.2
 * designed for PHP 5+
 *
 *-----------------------------------------------------------
 * Calcul des dates (jours fris) variables du calendrier
 * chrtien : Pques, Assension, Pentecte
 * Priode de validit : 1582 - 2500
 * version 1.0.1
 *
 *-----------------------------------------------------------
 * news in version 1.0.2
 * add Ash-Wednesday (mercredi des cendres) ! warning for bissextile years
 * add Good-Friday (vendredi saint)
 *
 *-----------------------------------------------------------
 *
 * @uses 
 * $var = new DatesSpeciales();
 * $var->setAnnee('2007');
 * echo $var->paquesLundi();
 */

class DatesSpeciales {
	private $annee;		// anne pour recherche des jours variables
	private $dateSp;	// date spciale
	
  /**
   * DatesSpeciales::setAnnee()
   *	
   * @param integer $y	:	2500 < anne (YYYY) > 1582
   * @return none
   */
	public function setAnnee($y)
	{
		if ($y > 1582 && $y < 2500)
			$this->annee = $y;
		else
			$this->annee = date("Y");
	}
	
  /**
   * DatesSpeciales::assension()
   * Calcul du jour de l'Assenssion par rapport au jour de Pques de l'anne
   * @return date	:	YYYY-mm-dd
   */
	public function assension()
	{
		$this->dateSp = $this->paquesDimanche();
		$this->ajouteJ($this->dateSp, 39);
		return date('Y-m-d',$this->dateSp);
	}
	
  /**
   * DatesSpeciales::cendresMercredi()
   * Calcul du mercredi des cendres (Dimanche -45/-46)
   * !!! DOIT TENIR COMPTE DES ANNEES BISSEXTILES ET CENTENAIRES !!!
   * @return date	:	YYYY-mm-dd
   */
	public function cendresMercredi()
	{
		$this->dateSp = $this->paquesDimanche();
		$bisx = ($this->annee / 4.0) - floor($this->annee / 4.0);
		$cent = ($this->annee / 100.0) - floor($this->annee / 100.0);
		if ($bisx > 0)	$delJ = -45;	else	$delJ= -46;
		if ($cent == 0.0)	$delJ = -45;
		$this->ajouteJ($this->dateSp, floatval($delJ));
		return date('Y-m-d',$this->dateSp);
	}
	
  /**
   * DatesSpeciales::vendrediSaint()
   * Calcul du Vendredi Saint (Dimanche -2)
   * @return date	:	YYYY-mm-dd
   */
	public function vendrediSaint()
	{
		$this->dateSp = $this->paquesDimanche();
		$this->ajouteJ($this->dateSp, floatval(-2));
		return date('Y-m-d',$this->dateSp);
	}
	
  /**
   * DatesSpeciales::pentecoteLundi()
   * Calcul du Lundi de Pentecte (Dimanche +1)
   * @return date	:	YYYY-mm-dd
   */
	public function pentecoteLundi()
	{
		$this->dateSp = $this->pentecoteDimanche();
		$this->ajouteJ($this->dateSp, 1);
		return date('Y-m-d',$this->dateSp);
	}
	
  /**
   * DatesSpeciales::pentecoteDimanche()
   * Calcul du Dimanche de Pentecte par rapport au jour de Pques de l'anne
   * @return date	:	YYYY-mm-dd
   */
	public function pentecoteDimanche()
	{
		$this->dateSp = $this->paquesDimanche();
		$this->ajouteJ($this->dateSp, 49);
		return date('Y-m-d',$this->dateSp);
	}
	
  /**
   * DatesSpeciales::paquesLundi()
   * Calcul du Lundi de Pques (Dimanche +1)
   * @return date	:	YYYY-mm-dd
   */
	public function paquesLundi()
	{
		$pd = $this->paquesDimanche();
		$this->ajouteJ($pd, 1);
		return date('Y-m-d',$pd);
	}
	
  /**
   * DatesSpeciales::paquesDimanche()
   * Calcul du Jour de Pques (Dimanche)
   * @return date	:	YYYY-mm-dd
   */
	public function paquesDimanche()
	{
		$lpq = $this->paquesJ();
		return $this->annee.'-'.$lpq[mois].'-'.$lpq[jour];
	}
	
  /**
   * DatesSpeciales::ajouteJ()
   * Ajoute(ou soustrait) un nombre de jour  une date
   * @param Date $who	:	(YYYY-mm-dd)
   * @param integer $nj	:	nb de jours
   * @return timastamp (January 1 1970 00:00:00 GMT) : nouvelle date
   */
	private function ajouteJ(&$who, $nj)
	{
		//if ($nj > 0)
			$who = strtotime($who) + floatval(86400 * $nj);
		//else
		//	$who = strtotime($nj.' days', strtotime($who));
	}
	
  /**
   * DatesSpeciales::paquesJ()
   * Calcul exact du jour de Pques pour anne > 1582
   * Algorithme de Jean MEEUS - Socit Astronomique de France (c) 1988
   * @return array() : mois, jour
   */
	private function paquesJ()
	{
		$a = $this->annee - (19 * floor($this->annee / 19));
		$b = floor($this->annee / 100);
		$c = $this->annee - (100 * floor($this->annee / 100));
		$d = floor($b / 4);
		$e = $b - (4 * floor($b / 4));
		$f = floor(($b + 8) / 25);
		$g = floor(($b - $f + 1) / 3);
		$hi = (19 * $a) + $b - $d - $g + 15;
		$h = $hi - (30 * floor($hi / 30));
		$i = floor($c / 4);
		$k = $c - (4 * floor($c / 4));
		$qi = 32 + (2 * $e) + (2 * $i) - $h - $k;
		$q = $qi - (7 * floor($qi / 7));
		$mi = $a + (11 * $h) + (22 * $q);
		$m = floor($mi / 451);
		$o = $h + $q - (7 * $m) + 114;
		$n = floor($o / 31);
		$p = $o - (31 * floor($o / 31));
		$dim = $p + 1;
		$lun = $p + 2;
		if ($n < 10)
			$mois = '0'.$n;
		else
			$mois = $n;
		if ($dim < 10)
			$jours = '0'.$dim;
		else
			$jours = $dim;
		
		return array('mois'=>$mois,'jour'=>$jours);
	}
}

?>