﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Globalization;

namespace ContentHelper.Helpers
{
    public class UrlHelperEx : UrlHelper
    {
        #region Constants
        private const string c_VERSION_FORMAT = "{0}?v={1}";
        #endregion

        #region Initialization
        public UrlHelperEx(RequestContext requestContext)
            : base(requestContext)
        {
        }
        #endregion

        #region Public methods
        public string Content(string contentPath,bool forceupdate=false)
        {
            var content = base.Content(contentPath);

            if (!forceupdate) {
                return content.ToString();
            }
            else
            { 
                Version version = WebHelper.GetApplicationVersion(this.RequestContext.HttpContext);
                return string.Format(c_VERSION_FORMAT, content
                        , version.ToString());
            }
        }
        #endregion  
    }

    
    public abstract class WebViewPageEx : WebViewPage
    {
        #region Properties
        public new UrlHelperEx Url
        {
            get;
            set;
        }
        
        #endregion

        #region Public methods
        public override void InitHelpers()
        {
            base.InitHelpers();
            Url = new UrlHelperEx(ViewContext.RequestContext);
        }
        #endregion
    }
    
    public abstract class WebViewPageEx<T> : WebViewPage
    {
        #region Properties
        public new UrlHelperEx Url
        {
            get;
            set;
        }
        #endregion

        #region Public methods
        public override void InitHelpers()
        {
            base.InitHelpers();
            Url = new UrlHelperEx(ViewContext.RequestContext);
        }
        #endregion
    }
}