﻿using System;
using System.Collections;
using System.Text;
using System.Collections.Generic;
using System.Reflection;
using System.Linq;
using System.Linq.Expressions;
using System.Web.Mvc;
using System.Web.Mvc.Html;
using System.Web.Routing;

namespace MvcApplication2.Extensions
{
    public static class HtmlExtensions
    {
        public static MvcHtmlString EditorForCollection_old<TModel, TValue>(this HtmlHelper<TModel> htmlHelper,
                                                                        Expression<Func<TModel, TValue>> expression,
                                                                        string objname)
        {
            // just use this for now
            // <input type="text" name="id[0]" value="1" />

            StringBuilder htmlBuilder = new StringBuilder();

            Func<TModel, TValue> deleg = expression.Compile();
            var result = deleg(htmlHelper.ViewData.Model);

            if (result != null)
            {
                IEnumerable source = result as IEnumerable;

                int i = 0;
                foreach (var item in source)
                {
                    string st = item.ToString();

                    // build input tag
                    TagBuilder inputTag = new TagBuilder("input");

                    inputTag.Attributes.Add("type", "text");
                    inputTag.Attributes.Add("name", objname + "[" + i.ToString() + "]");
                    inputTag.Attributes.Add("value", st);

                    i++;
                    htmlBuilder.Append(inputTag.ToString(TagRenderMode.Normal));
                }
            }

            return MvcHtmlString.Create(htmlBuilder.ToString());
        }

        public static MvcHtmlString EditorForCollection<TModel, TValue>(this HtmlHelper<TModel> htmlHelper,
                                                                    Expression<Func<TModel, TValue>> expression,
                                                                    string objname)
        {
            StringBuilder htmlBuilder = new StringBuilder();

            Func<TModel, TValue> deleg = expression.Compile();
            var result = deleg(htmlHelper.ViewData.Model);

            if (result != null)
            {
                IEnumerable source = result as IEnumerable;

                int i = 0;
                foreach (var item in source)
                {
                    Type type = item.GetType();


                    if (!type.IsValueType && !type.Name.Equals("String"))
                    {
                        // Get the public properties.
                        PropertyInfo[] propInfo = type.GetProperties(BindingFlags.DeclaredOnly | BindingFlags.Public | BindingFlags.Instance);

                        foreach (var prop in propInfo)
                        {
                            TagBuilder inputTag = new TagBuilder("input");
                            inputTag.Attributes.Add("type", "text");

                            inputTag.Attributes.Add("name", objname + "[" + i.ToString() + "]." + prop.Name);
                            inputTag.Attributes.Add("value", (string)prop.GetValue(item));
                        
                            htmlBuilder.Append(inputTag.ToString(TagRenderMode.Normal));
                        }
                    }
                    else
                    {
                        TagBuilder inputTag = new TagBuilder("input");
                        inputTag.Attributes.Add("type", "text");

                        inputTag.Attributes.Add("name", objname + "[" + i.ToString() + "]");
                        inputTag.Attributes.Add("value", item.ToString());

                        htmlBuilder.Append(inputTag.ToString(TagRenderMode.Normal));
                    }

                    i++;
                }
            }

            return MvcHtmlString.Create(htmlBuilder.ToString());
        }

    }
}