<?php
/*
 * Copy your Lipsum.php class to directory from which your classes are loaded
 * from. Otherwise, copy it to the directory where your template file is and
 * uncomment the following line.
 */
//include 'Lipsum.php';

// Simple way to do so
echo Lipsum::Generate(5, 'paragraphs', false, false) . PHP_EOL . PHP_EOL;

// We can as well make a class and use full advantages of it.
$lipsum = new Lipsum(5, 'lists', false, true);

echo $lipsum->render() . PHP_EOL . PHP_EOL;

$lipsum->setAmount(3);

echo $lipsum->render() . PHP_EOL . PHP_EOL;
echo $lipsum->render() . PHP_EOL . PHP_EOL;

$lipsum->setTags(false);

echo $lipsum->render() . PHP_EOL . PHP_EOL;
echo $lipsum->render() . PHP_EOL . PHP_EOL;

$lipsum->setWhat('paragraphs');

echo $lipsum->render() . PHP_EOL . PHP_EOL;

$lipsum->setTags(true);

echo $lipsum->render() . PHP_EOL . PHP_EOL;

$lipsum->setAmount(10);
$lipsum->setWhat('words');

echo $lipsum->render() . PHP_EOL . PHP_EOL;
echo $lipsum->render() . PHP_EOL . PHP_EOL;
echo $lipsum->render() . PHP_EOL . PHP_EOL;

// Now we can generate lipsums from cache.
echo $lipsum->random('paragraphs') . PHP_EOL . PHP_EOL;
echo $lipsum->random('lists') . PHP_EOL . PHP_EOL;
echo $lipsum->random('words') . PHP_EOL . PHP_EOL;
?>