﻿<%@ Page Language="C#" %>

<script runat="server">
	
	protected override void OnLoad(EventArgs e)
	{
		base.OnLoad(e);

		this.zipFileRepeater.DataSource = Elsinore.Website.Utility.GetVirtualFilePaths("~/Content", this.Context);
		this.zipFileRepeater.DataBind();
	}
	
</script>

<html>
<head>
	<title>Zip Entry Example Page</title>
</head>
<body>
	<asp:Repeater runat="server" ID="zipFileRepeater">
		<ItemTemplate>
			<p>
				<asp:HyperLink runat="server" NavigateUrl="<%# Container.DataItem %>">
					Download <%# Container.DataItem %>
				</asp:HyperLink>
			</p>
			<p>
				Contents:</p>
			<ul>
				<asp:Repeater runat="server" DataSource="<%# Elsinore.Website.ZipEntryHandler.GetZipEntries((string)Container.DataItem, this.Context) %>">
					<ItemTemplate>
						<li>
							<asp:HyperLink runat="server" NavigateUrl="<%# ((Elsinore.Website.ZipEntryInfo)Container.DataItem).Url %>">
								View <%# ((Elsinore.Website.ZipEntryInfo)Container.DataItem).Name %>
							</asp:HyperLink>
						</li>
					</ItemTemplate>
				</asp:Repeater>
			</ul>
			<br />
		</ItemTemplate>
	</asp:Repeater>
</body>
</html>
