﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace UDTID.InputModels
{
    public class Employee
    {
        [Required(ErrorMessage = "Enter employee name!")]
        [Display(Name="Employee name")]
        [StringLength(100, ErrorMessage = "The {0} must be at least {2} characters long.", MinimumLength = 6)]
        public string Name { get; set; }
        
        [Required(ErrorMessage="Job position is required!")]
        [Display(Name = "Job position")]
        public int JobPosition { get; set; }

        public List<Skill> Skills { get; set; }

        public Employee()
        {
            Skills = new List<Skill>();
        }
    }

    public class Skill
    {
        [Required(ErrorMessage = "Describe skill!")]
        public string Title { get; set; }

        [Required(ErrorMessage = "Select skill level!")]
        public string Level { get; set; }
    }
}