using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.Sql;
using System.Data.SqlClient;
using System.Text;

public partial class _Default : System.Web.UI.Page
{
    string connString = ConfigurationManager.ConnectionStrings["TestarticlesConnectionString1"].ConnectionString;

    SqlDataAdapter da = null;
    DataTable table = null;
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            fillDatalist();
        }        

        UpdateColors();        
    }

    private void fillDatalist()
    {
        using (SqlConnection sqlConn = new SqlConnection(connString))
        {
            string strSQL = "SELECT [id],[StuName],[Type],convert(varchar,[DateOfBirth],103) as [DateOfBirth],[Age] FROM [tblStuDetails]";
            using (da = new SqlDataAdapter(strSQL, sqlConn))
            {
                if (sqlConn.State != ConnectionState.Open)
                {
                    sqlConn.Open();
                }

                using (table = new DataTable())
                {
                    da.Fill(table);

                    if (table.Rows.Count > 0)
                    {
                        DataList1.DataSource = table;
                        DataList1.DataBind();
                    }
                }                
            }
        }
    }   

    private void UpdateColors()
    {
        foreach (DataListItem item in DataList1.Items)
        {
            Label lbl = (Label)item.FindControl("Label1");
            switch (lbl.Text)
            {
                case "F":
                    item.BackColor = System.Drawing.Color.Blue;
                    break;
                case "A":
                    item.BackColor = System.Drawing.Color.Green;
                    break;
                case "H":
                    item.BackColor = System.Drawing.Color.Red;
                    break;
                case "G":
                    item.BackColor = System.Drawing.Color.Yellow;
                    break;
                case "B":
                    item.BackColor = System.Drawing.Color.Violet;
                    break;
            }
        }
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        string[] strSelected;
        string finalvalue = string.Empty;
        int recordsUpdated = 0;

        finalvalue = lblSelected.Text.Substring(0, lblSelected.Text.Length - 1);
        strSelected = finalvalue.Split(',');

        if (strSelected.Length > 0)
        {
            for (int i = 0; i < strSelected.Length; i++)
            {
                using (SqlConnection sqlConn = new SqlConnection(connString))
                {
                    string strSQLInsert = "insert into tblSelectedID(id) values(@strSelected)";
                    using (SqlCommand cmd =sqlConn.CreateCommand())
                    {
                        cmd.CommandText = strSQLInsert;
                        cmd.CommandType = CommandType.Text;
                        cmd.Parameters.AddWithValue("@strSelected", strSelected[i].ToString());

                        if (sqlConn.State != ConnectionState.Open)
                        {
                            sqlConn.Open();
                        }
                        recordsUpdated += cmd.ExecuteNonQuery();                       
                    }
                }
            }

            if (recordsUpdated > 0)
            {
                lblResult.Text = string.Format("{0} Records Saved Successfully", recordsUpdated);
            }
        }
    }
    

    protected void CheckBox1_CheckedChanged(object sender, EventArgs e)
    {
        StringBuilder sel = new StringBuilder();
        foreach (DataListItem li in DataList1.Items)
        {
            if (li.ItemType == ListItemType.Item || li.ItemType == ListItemType.AlternatingItem)
            {
                CheckBox cb = li.FindControl("CheckBox1") as CheckBox;
                if (cb != null)
                {
                    if (cb.Checked)
                    {
                        sel.Append(cb.Text + ",");
                    }
                }
            }
        }

        lblSelected.Text = sel.ToString();
    }
}