<?php

/**
 *  Antz_IntelliForm has 3 main purposes: 
 *    * Make hack attempts more cumbersome by seeding forms
 *    * Prevent the form from being re-submitted when you hit the back button
 *    * Save form data for when the page is re-visited
 *     
 *  The length of time that the form data is saved for is configurable in Antz_
 *      IntelliForm::expireTime
 *  Each page can save a form with a unique key name, so you can save many forms in 
 *      any one session
 *  You can delete a saved form using Antz_IntelliForm::clear(), this is good after 
 *      the form has been processed and the data does not need to be retained
 *  You can check if the form has been submitted by using Antz_IntelliForm::submitted() 
 *      ( returns boolean )
 */ 


error_reporting(E_ALL);
session_start();

// must define baseUrl in a constant for antiRepost in IntelliForm.php on line 80.
//   * No trailing slash 
define('BASE_URL', 'http://localhost');




// dummy functions for example purposes
    function do_some_check()
    {
        echo 'checking . . .<br />';
        if(strtolower($_POST['something']) == 'break') return true;
        else return false;
    }
    function do_some_process()
    {
        echo '. . . Processed!<br />';
    }
    // handy way to ensure no exceptions are thrown
    function post($key, $def='')
    {
        return (isset($_POST[$key])) ? $_POST[$key] : $def;
    }
// end dummy functions



// put this in the bootstrap index file before your controller dispatches, if you code that way
    include('IntelliForm.php');
  
    // prevent accidental submitting by refresh or back-button. 
    //   * Use after session_start() and before any output to the browser ( it uses header redirection )
    Antz_IntelliForm::antiRepost();
    
    // clear expired form data
    Antz_IntelliForm::purge();
    // set the seed variable
    $seed = Antz_IntelliForm::seed();
    // $smarty->assign('AntzSeed', $seed); // if using smarty
// end bootstrap



// put this in your controller method
    if(Antz_IntelliForm::submitted()){
        // form has been submitted
        // save the data in case they navigate away then come back to the page
        Antz_IntelliForm::save('some form');
        echo 'submitted . . . <br />';
        if(do_some_check()){
            do_some_process();
            // delete the form data because we have finished with it
            Antz_IntelliForm::clear('some form');
            unset($_POST);
        };// end if check()
    }else{
        // form not submitted, restore a previous form
        Antz_IntelliForm::restore('some form');
    };
    $something = post('something');
// end for controller method


?>


<form action="example.php" method="post">
<?php echo $seed ?>
<input type="text" name="something" value="<?php echo $something ?>">
<input type="submit">
</form>
