<?php

class Antz_IntelliForm
{
    // how long are forms kept for ( seconds )
    const expireTime = 300;
    
    /**
     * Save form contents for restoration later with Antz_IntelliForm::restore($key)
     */          
    public static function save($key, $expire='')
    {
        
        $expire = ($expire=='') ? (constant('Antz_IntelliForm::expireTime') + time()) : ($expire+time());
        if(!isset($_SESSION['intelliForm'])||!is_array($_SESSION['intelliForm']))$_SESSION['intelliForm']=array();
        $_SESSION['intelliForm'][$key]=$_POST;
        $_SESSION['intelliForm'][$key]['intelliFormExpires'] = $expire;
    }
    
    /** 
     * Restore form contents from a previous save
     */         
    public static function restore($key)
    {
        $_POST = (isset($_SESSION['intelliForm'][$key])) ? $_SESSION['intelliForm'][$key] : array();
    }
    
    /**
     * Clear a saved form
     */         
    public static function clear($key)
    {
        if(isset($_SESSION['intelliForm'][$key])) unset($_SESSION['intelliForm'][$key]);
    }

    /**
     * clear all expired saves
     */         
    public static function purge()
    {
        if(isset($_SESSION['intelliForm'])&&is_array($_SESSION['intelliForm'])){
            foreach($_SESSION['intelliForm'] as $key=>$post){
                if($post['intelliFormExpires']<= time()){
                    unset($_SESSION['intelliForm'][$key]);
                };
            };
        };
        // clear form seeds ( max 15 forms per page)
        while(isset($_SESSION['antzSeed']) && count($_SESSION['antzSeed']) > 15){
            array_shift($_SESSION['antzSeed']);
        };
    }
    
     /**
     * Call this before processing any submitted data, to bypass the pesty confirm prompt
     * that appears when resubmitting post content.
     *   * Must be after session_start(); and after BASE_URL is defined     
     */              
    public static function antiRepost()
    {
        if(isset($_POST['antzSeed'])){
            // store the $_POST data in the session
            $_SESSION['post']=$_POST;
            // store the uploaded files in the session
            foreach($_FILES as $k=>$file){
                $suffix = rand(0,999);
                if($file['tmp_name']=='')continue;
                rename($file['tmp_name'], TEMP_DIR.'/'.$file['name'].$suffix);
                $_FILES[$k]['tmp_name']=TEMP_DIR.'/'.$file['name'].$suffix;
                chmod(TEMP_DIR.'/'.$file['name'].$suffix, 0777);
            };
            $_SESSION['files']=$_FILES;
            // get the page to head to next
            $nxt = $_SERVER['REQUEST_URI'];
            // remove leading slash
            while(substr($nxt, 0, 1)=='/'){
                $nxt = substr($nxt, 1, (strlen($nxt)-1));
            };
            // redirect to the same page 
            header('location:'.BASE_URL.'/'.$nxt);
            exit;
        }elseif(isset($_SESSION['post'])){
            // restore $_POST data from session
            $_POST=$_SESSION['post'];
            $_FILES=$_SESSION['files'];
            unset($_SESSION['post']);
        };
    }

    /**
     * Checks to see if the form has been submitted with a valid seed
     */         
    public static function submitted()
    {
        if(!isset($_POST['antzSeed'])){return false;};
        $seed = $_POST['antzSeed'];
        if(!isset($_SESSION['antzSeed'])||!is_array($_SESSION['antzSeed'])){$_SESSION['antzSeed']=array();};
        if(in_array($seed, $_SESSION['antzSeed'])){
            $tmp = array_flip($_SESSION['antzSeed']);
            $_SESSION['antzSeed'][$tmp[$seed]]=mt_rand(0,99999999);
            unset($tmp, $seed);
            return true;
        }else{
            return false;
        };
    }
    
    /**
     * Plant a seed to ensure forms are accepted by a verified session. 
     * Check with Antz_IntelliForm::submitted()
     */         
    public static function seed()
    {
        $seed = mt_rand(0,99999999);
        if(!isset($_SESSION['antzSeed'])||!is_array($_SESSION['antzSeed'])){$_SESSION['antzSeed']=array();};
        $_SESSION['antzSeed'][]=$seed;
        return '<input type="hidden" name="antzSeed" value="'.$seed.'">';
    }



}
