﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Middelpat.GoogleAnalytics
{
    public class TransactionItem
    {
        private readonly string _utmt = "item";

        private string _utmtid;     //OrderId
        private string _utmipc;     //Product code
        private string _utmipn;     //Product name
        private string _utmipr;     //Product price (unit price)
        private string _utmiqt;     //Quantity
        private string _utmiva;     //Product category

        /// <summary>
        /// Create a new TransactionItem
        /// </summary>
        /// <param name="productPrice">The unit price of the item</param>
        /// <param name="category">The product category or varition</param>
        public TransactionItem(string productCode, string productName, decimal productPrice, int quantity, string category)
        {
            _utmipc = Uri.EscapeDataString(productCode);
            _utmipn = Uri.EscapeDataString(productName);
            _utmipr = productPrice.ToString("F");
            _utmiqt = quantity.ToString();
            _utmiva = Uri.EscapeDataString(category);
        }

        public string CreateParameterString()
        {
            return string.Format("utmt={0}&utmtid={1}&utmipc={2}&utmipn={3}&utmipr={4}&utmiqt={5}&utmiva={6}",
                                 _utmt,
                                 _utmtid,
                                 _utmipc,
                                 _utmipn,
                                 _utmipr,
                                 _utmiqt,
                                 _utmiva);
        }

        #region get set

        /// <summary>
        /// The orderId will be set automatically when the item is being added to the Transaction
        /// </summary>
        public int OrderId
        {
            set
            {
                _utmtid = value.ToString();
            }
        }

        #endregion
    }
}
