﻿using System;
using System.Web;
using System.Collections.Generic;

namespace Middelpat.GoogleAnalytics
{
    public class Transaction : IGoogleEvent
    {        
        private readonly string _utmt = "tran";

        private int _orderId;           //(utmtid)

        private string _utmtci;        //Billing city
        private string _utmtco;        //Billing country
        private string _utmtrg;        //Billing region
        private string _utmtst;        //Store name / affiliation
        private string _utmtsp;        //Shipping costs
        private string _utmtto;        //Ordertotal
        private string _utmttx;        //Tax costs

        /// <summary>
        /// Create a new Ecommerce Transaction
        /// </summary>
        /// <param name="storeName">Name of the webstore or affiliation</param>
        /// <param name="schippingCosts">Total shipping costs for this order/transaction</param>
        /// <param name="orderTotal">Total costs of this order/transaction including tax and shipping costs</param>
        /// <param name="taxCosts">Total tax costs on this order/transaction</param>
        public Transaction(int orderId, string billingCity, string country, string region, string storeName, decimal shippingCosts, decimal orderTotal, decimal taxCosts)
        {
            _items = new List<TransactionItem>();

            _orderId = orderId;

            _utmtci = Uri.EscapeDataString(billingCity);
            _utmtco = Uri.EscapeDataString(country);
            _utmtrg = Uri.EscapeDataString(region);
            _utmtst = Uri.EscapeDataString(storeName);
            _utmtsp = shippingCosts.ToString("F").Replace(',', '.');
            _utmtto = orderTotal.ToString("F").Replace(',', '.');
            _utmttx = taxCosts.ToString("F").Replace(',', '.');
        }

        public void AddTransactionItem(TransactionItem item)
        {
            item.OrderId = _orderId;

            Items.Add(item);
        }

        public string CreateParameterString()
        {
            return string.Format("utmt={0}&utmtci={1}&utmtco={2}&utmtrg={3}&utmtid={4}&utmtst={5}&utmtsp={6}&utmtto={7}&utmttx={8}",
                                 _utmt,
                                 _utmtci,
                                 _utmtco,
                                 _utmtrg,
                                 _orderId.ToString(),
                                 _utmtst,
                                 _utmtsp,
                                 _utmtto,
                                 _utmttx);       
        }

        private List<TransactionItem> _items;
        public List<TransactionItem> Items
        {
            get
            {
                return _items;
            }
            private set
            {
                _items = value;
            }
        }
    }
}
