﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Data;
using System.Data.SqlClient;
using System.Web.Configuration;

/// <summary>
/// Summary description for EmployeeWebService
/// </summary>
[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
[System.Web.Script.Services.ScriptService]
public class hr_webservice : System.Web.Services.WebService
{

    List<Employee> list = new List<Employee>();

    public hr_webservice()
    {

    }

    //
    // Get Employee List from Database, This is a sample code for getting the data from database, you can use procedure to get insted of 
    // inline query
    //

    [WebMethod]
    public List<Employee> GetEmployeeDetails()
    {
        // getting connection string
        string conStr = WebConfigurationManager.ConnectionStrings["TESTDB"].ConnectionString;
        DataTable dt = new DataTable();
        SqlDataReader dr = null;
        // Creating Sql Connection
        using (SqlConnection conn = new SqlConnection(conStr))
        {
            // Creating insert statement
            string sql = string.Format(@"Select * from [SampleInfoTable]");
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandText = sql;
            cmd.CommandType = CommandType.Text;
            conn.Open();

            dr = cmd.ExecuteReader();
            dt.Load(dr);
            conn.Close();
            cmd = null;
        }

        int countRow = dt.Rows.Count;

        foreach (DataRow drEmp in dt.Rows)
        {
            Employee objemployee = new Employee();
            objemployee.id = Convert.ToInt32(drEmp["id"].ToString());
            objemployee.Name = drEmp["Name"].ToString();
            objemployee.Email = drEmp["Email"].ToString();
            objemployee.Phone = drEmp["Phone"].ToString();
            objemployee.Address = drEmp["Address"].ToString();
            list.Add(objemployee);
        }
        return list;
    }




   
    [WebMethod]
    public List<Employee> DeleteEmployeeData(string employeeId)
    {

        // getting connection string
        string conStr = WebConfigurationManager.ConnectionStrings["TESTDB"].ConnectionString;
        int rowsInserted = 0;
        // Creating Sql Connection
        using (SqlConnection conn = new SqlConnection(conStr))
        {
            // Creating insert statement
            string sql = string.Format(@"Delete [SampleInfoTable] WHERE id='" + employeeId + "'");
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandText = sql;
            cmd.CommandType = CommandType.Text;
            conn.Open();
            rowsInserted = cmd.ExecuteNonQuery();
            conn.Close();
            cmd = null;
        }

        list = GetEmployeeDetails();
        return list;

    }



    //
    // Edit Employee Data
    //
    [WebMethod]
    public List<Employee> EditEmployeeData(string employeeId, string editedName, string editedEmail, string editedPhone, string editedAddress, string action_mode)
    {

        // getting connection string
        string conStr = WebConfigurationManager.ConnectionStrings["TESTDB"].ConnectionString;
        int rowsInserted = 0;
        // Creating Sql Connection
        using (SqlConnection conn = new SqlConnection(conStr))
        {
            SqlCommand cmd = new SqlCommand();
            cmd.Connection = conn;
            cmd.CommandText = "sp_sample_info";
            cmd.CommandType = CommandType.StoredProcedure;

            cmd.Parameters.Add("@id", employeeId);
            cmd.Parameters.Add("@Name", editedName);
            cmd.Parameters.Add("@Email", editedEmail);
            cmd.Parameters.Add("@Phone", editedPhone);
            cmd.Parameters.Add("@Address", editedAddress);
            cmd.Parameters.Add("@Action", action_mode);



            conn.Open();
            rowsInserted = cmd.ExecuteNonQuery();
            conn.Close();
            cmd = null;
        }

        list = GetEmployeeDetails();
        return list;

    }



}

public class Employee
{
    public int id { get; set; }
    public string Name { get; set; }
    public string Email { get; set; }
    public string Phone { get; set; }
    public string Address { get; set; }
}

