﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
//
using System.Data;
using System.Data.SqlClient;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace MvcApp.Controllers
{
    public class TestController : Controller
    {
        string connectionString = "data source=.\\SQLEXPRESS;attachdbfilename=|DataDirectory|\\NORTHWND.MDF;integrated security=True;user instance=True;multipleactiveresultsets=True;";

        //
        // GET: /Test/

        public ActionResult Index()
        {
            return View();
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult LoadGridData(string sidx, string sord, int page, int rows, bool _search, string searchField, string searchOper, string searchString, string tableName)
        {
            DataTable t_data = new DataTable();
            DataTable t_struct = new DataTable();

            string strSQL = string.Format("SELECT * FROM [{0}]", tableName);
            if (!string.IsNullOrEmpty(sidx))
                strSQL = string.Format("SELECT * FROM [{0}] ORDER BY [{1}] {2}", tableName, sidx, sord);

            SqlConnection cn = new SqlConnection(connectionString);
            using (cn)
            {
                //struct
                SqlDataAdapter a_struct = new SqlDataAdapter(strSQL, cn);
                a_struct.FillSchema(t_struct, SchemaType.Source);

                //date
                SqlDataAdapter a_data = new SqlDataAdapter(strSQL, cn);
                a_data.Fill(t_data);
            }

            string pk = GetTableFirstPrimaryKeyName(t_struct);
            string[] properties = new string[t_struct.Columns.Count];
            Type[] types = new Type[t_struct.Columns.Count];

            for (int i = 0; i < t_struct.Columns.Count; i++)
            {
                DataColumn dc = t_struct.Columns[i];
                properties[i] = dc.ColumnName;
                types[i] = dc.DataType;
            }

            string jsonstring = JsonConvert.SerializeObject(t_data, Formatting.Indented);

            GridResult jsonResults = null;

            JContainer obarr = (JContainer)JsonConvert.DeserializeObject(jsonstring);
            jsonResults = obarr.ToJQGridResult(page, rows, sidx, sord, pk, properties, types);

            return Content(jsonResults.ToJson());
        }

        public string InjectScript(string tableName)
        {
            string colNames = "colNames: [";
            string colModel = "colModel: [";

            string pk = string.Empty;

            SqlConnection cn = new SqlConnection(connectionString);
            using (cn)
            {
                DataTable t_struct = new DataTable();
                string strSQL = string.Format("SELECT * FROM [{0}]", tableName);

                SqlDataAdapter a_struct = new SqlDataAdapter(strSQL, cn);
                a_struct.FillSchema(t_struct, SchemaType.Source);

                foreach (DataColumn c in t_struct.Columns)
                {
                    colNames += "'" + c.ColumnName + "', ";
                    colModel += "{ name: '" + c.ColumnName + "', index: '" + c.ColumnName + "' }, ";
                }

                colNames += "]";
                colModel += "]";

                colNames = colNames.Replace(", ]", " ]");
                colModel = colModel.Replace(", ]", " ]");

                pk = GetTableFirstPrimaryKeyName(t_struct);
            }

            if (string.IsNullOrEmpty(pk))
            {
                return
                    string.Format("alert('Table/View [{0}] does not have primary key')", tableName);
            }

            string r1 =
                @"function createJQGrid(tblListName, divPagerName, tableName) { 
                    var listName = '#' + tblListName;
                    var pagerName = '#' + divPagerName;

                    try {
                        var obg = $(listName);
                        if (obg != null) {
                            jQuery(listName).jqGrid({
                                url: '',
                        datatype: 'json',
                        mtype: 'POST',
                        autowidth: true,
                        height: '100%',
                        loadtext: 'Loading...',";
            string r2 =
                      @"pgtext: '{0} / {1}',
                        recordtext: '{0} - {1} / {2}',
                        rowList: [10, 20, 30],
                        rowNum: 10,
                        pager: jQuery(pagerName),
                        sortname: '" + pk + "'," +
                      @"viewrecords: true,
                        gridview: true,
                        sortorder: 'asc',
                        caption: tableName,
                        emptyrecords: 'Nu exista inregistrari',
                        autosearch: false,
                        jsonReader: {
                            root: 'rows',
                            page: 'page',
                            total: 'total',
                            records: 'records',
                            repeatitems: true,
                            cell: 'cell'," +
                            "id: '" + pk + "' " +
                      @"}
                    }).navGrid(pagerName, { edit: false, add: false, del: false, search: true, searchtext: '' });
                }
            }
            catch (err) {
                alert(err.description);
            }
        };";

            string r3 = string.Format("createJQGrid('list', 'pager', '{0}');", tableName);

            string retval =
                r1 + colNames + ", " + colModel + ", " + r2 + r3;


            return
                retval;
        }

        string GetTableFirstPrimaryKeyName(DataTable tbl)
        {
            string retval = string.Empty;

            if (tbl.PrimaryKey.Count() > 0)
                retval = tbl.PrimaryKey[0].ColumnName;
            else
                //we can use first column
                retval = tbl.Columns[0].ColumnName;
            return retval;
        }

        public string[] GetTables()
        {
            string[] retval = null;

            DataTable tblSchema = new DataTable();
            SqlConnection cn = new SqlConnection(connectionString);
            
            using (cn)
            {
                //GetSchema example
                //http://msdn.microsoft.com/en-us/library/ms254934%28v=vs.80%29.aspx

                cn.Open();
                tblSchema = cn.GetSchema("Tables");
                cn.Close();
            }

            retval = new string[tblSchema.Rows.Count];
            for (int i = 0; i < tblSchema.Rows.Count; i++)
            {
                retval[i] = tblSchema.Rows[i][2] as string;
                //string type = tblSchema.Rows[i][3] as string; type is "BASE TABLE" or "VIEW"
            }

            Array.Sort(retval);

            return retval;
        }

        public string LoadTableNames()
        {
            string sep = "*";
            string[] tbls = GetTables();
            return string.Join(sep, tbls);
        }
    }
}
