﻿using System;
using System.Linq;
using System.Linq.Expressions;
using System.Collections.Generic;
using System.Reflection;
using Newtonsoft.Json;
using System.Text;
using System.IO;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
//
using Newtonsoft.Json.Linq;

//this part is from here 
//http://www.sieena.com/blog/archive/2011/07/19/convert-any-list-to-valid-jqgrid-json-object-.aspx
//By David Espino

public class GridResult
{
    //Actual Page
    public string page { get; set; }

    //Number of pages to display
    public int total { get; set; }

    //Number of rows to display
    public string records { get; set; }

    //items
    public List<GridRow> rows { get; set; }
}

public class GridRow
{
    public string id { get; set; }

    public string[] cell { get; set; }
}

public class PagingArguments
{
    public int page { get; set; }

    public int limit { get; set; }

    public int start { get; set; }

    public int totalPages { get; set; }
}

public class GridRequest
{
    public int Page { get; set; }

    public int Limit { get; set; }

    public string SortIndex { get; set; }

    public string SortOrder { get; set; }
}

public static class JQGridExtensions
{
    //Method to do the sorting and the paging of the grid
    public static IQueryable<T> SortBy<T>(this IQueryable<T> source, string propertyName)
    {
        if (source == null)
        {
            throw new ArgumentNullException("source");
        }

        // DataSource control passes the sort parameter with a direction
        // if the direction is descending          

        int descIndex = propertyName.IndexOf(" DESC");

        int ascIndex = propertyName.IndexOf(" ASC");

        if (descIndex >= 0)
        {
            propertyName = propertyName.Substring(0, descIndex).Trim();
        }

        if (ascIndex >= 0)
        {
            propertyName = propertyName.Substring(0, ascIndex).Trim();
        }

        if (String.IsNullOrEmpty(propertyName))
        {
            return source;
        }

        ParameterExpression parameter = Expression.Parameter(source.ElementType, String.Empty);

        try
        {
            MemberExpression property = Expression.Property(parameter, propertyName);

            LambdaExpression lambda = Expression.Lambda(property, parameter);

            string methodName = (descIndex < 0) ? "OrderBy" : "OrderByDescending";

            Expression methodCallExpression = Expression.Call(typeof(Queryable), methodName,
                                                new Type[] { source.ElementType, property.Type },
                                                source.Expression, Expression.Quote(lambda));

            return source.Provider.CreateQuery<T>(methodCallExpression);
        }
        catch (Exception ex)
        {
        }

        return source;
    }

    //Method to create a list of GridRow according to the selected properties
    public static List<GridRow> ToGridRowListOriginal<T>(this IQueryable<T> source, string id, string[] properties)
    {
        List<GridRow> result = new List<GridRow>();

        if (source == null)
        {
            throw new ArgumentNullException("source");
        }

        if (string.IsNullOrEmpty(id))
        {
            throw new ArgumentNullException("id");
        }

        if (properties == null || properties.Length == 0)
        {
            throw new ArgumentNullException("properties");
        }

        // string test = "dafdas";
        foreach (var item in source)
        {
            try
            {
                GridRow row = new GridRow();

                Type type = item.GetType();

                //Use a bit of reflection to get the property names an values
                PropertyInfo info = type.GetProperty(id);
                //if (info == null) continue;

                row.id = info.GetValue(item, null).ToString();

                row.cell = new string[properties.Length];

                for (int i = 0; i < properties.Length; i++)
                {
                    info = type.GetProperty(properties[i]);
                    object obcell = info.GetValue(item, null);
                    if (obcell != null)
                    {
                        switch (obcell.GetType().FullName)
                        {
                            case "System.DateTime":
                                DateTime dt;
                                DateTime.TryParse(obcell.ToString(), out dt);
                                row.cell[i] = dt.ToString("dd.MM.yyyy");
                                break;
                            case "Syste.String":
                            default:
                                row.cell[i] = obcell.ToString();
                                break;
                        }
                    }
                    else
                        //row.cell[i] = "...";
                        row.cell[i] = string.Empty;
                }

                result.Add(row);
            }
            catch (Exception ex)
            {
                ex.ToString();
            }
        }

        return result;
    }

    public static List<GridRow> ToGridRowList<T>(this IQueryable<T> source, string id, string[] properties)
    {
        List<GridRow> result = new List<GridRow>();

        if (source == null)
        {
            throw new ArgumentNullException("source");
        }

        if (string.IsNullOrEmpty(id))
        {
            throw new ArgumentNullException("id");
        }

        if (properties == null || properties.Length == 0)
        {
            throw new ArgumentNullException("properties");
        }

        // string test = "dafdas";
        foreach (var item in source)
        {
            try
            {
                GridRow row = new GridRow();

                Type type = item.GetType();

                //Use a bit of reflection to get the property names an values
                PropertyInfo info = type.GetProperty(id);
                if (info == null) continue;

                row.id = info.GetValue(item, null).ToString();
                row.cell = new string[properties.Length];

                for (int i = 0; i < properties.Length; i++)
                {
                    info = type.GetProperty(properties[i]);
                    object obcell = info.GetValue(item, null);
                    if (obcell != null)
                    {
                        switch (obcell.GetType().FullName)
                        {
                            case "System.DateTime":
                                DateTime dt;
                                DateTime.TryParse(obcell.ToString(), out dt);
                                row.cell[i] = dt.ToString();
                                break;
                            case "Syste.String":
                            default:
                                row.cell[i] = obcell.ToString();
                                break;
                        }
                    }
                    else
                        //row.cell[i] = "...";
                        row.cell[i] = string.Empty;
                }

                result.Add(row);
            }
            catch (Exception ex)
            {
                ex.ToString();
            }
        }

        return result;
    }

    //Method to Create a Json from any Object
    public static string ToJson<T>(this T obj)
    {
        return ToJson<T>(obj, SerializerType.JavaScriptSerializer);
    }

    //Method to Create a Json from any Object
    public static string ToJson<T>(this T obj, SerializerType type)
    {
        string retval = "{}";

        if (obj != null)
        {
            switch (type)
            {
                case SerializerType.DataContractSerializer:
                    {
                        DataContractJsonSerializer dcs = new DataContractJsonSerializer(typeof(T));
                        MemoryStream stream = new MemoryStream();
                        dcs.WriteObject(stream, obj);
                        retval = Encoding.UTF8.GetString(stream.ToArray());

                        stream.Close();
                        stream.Dispose();

                        break;
                    }
                case SerializerType.JavaScriptSerializer:
                default:
                    {
                        JavaScriptSerializer jss = new JavaScriptSerializer();
                        retval = jss.Serialize(obj);
                        break;
                    }
            }
        }

        return retval;
    }

    private static PagingArguments GetPagingVariables(int countItems, int page, int limit)
    {
        PagingArguments arguments = new PagingArguments();

        //Set initial Values
        arguments.page = page;
        arguments.limit = limit;

        //Prepare paging variables           
        float numberOfPages = (float)countItems / (float)limit;

        if (countItems > 0)
        {
            arguments.totalPages = (int)Math.Ceiling(numberOfPages);
        }

        //At least one page
        if (arguments.totalPages == 0)
        {
            arguments.totalPages = 1;
        }

        //Set actual page
        if (arguments.page > arguments.totalPages)
        {
            arguments.page = arguments.totalPages;
        }

        if (arguments.limit < 0)
        {
            arguments.limit = 0;
        }

        //Get paging variables
        arguments.start = arguments.limit * arguments.page - arguments.limit;
        if (arguments.start <= 0)
        {
            arguments.start = 0;
        }

        return arguments;
    }

    public static GridRequest ToGridRequest(this System.Collections.Specialized.NameValueCollection parameters)
    {
        GridRequest request = null;

        if (parameters["page"] != null && parameters["rows"] != null && parameters["sidx"] != null && parameters["sord"] != null)
        {
            int page = 0;
            int rows = 0;

            Int32.TryParse(parameters["page"], out page);
            Int32.TryParse(parameters["rows"], out rows);

            request = new GridRequest();
            request.Page = page;
            request.Limit = rows;
            request.SortIndex = parameters["sidx"];
            request.SortOrder = parameters["sord"];
        }

        return request;
    }

    public static GridResult ToJQGridResult<T>(this List<T> response, int page, int limit, string sortIndex, string sortOrder, string idColumn, string[] properties)
    {
        //Set the first column as sort order by Default
        PagingArguments arguments = GetPagingVariables(response.Count(), page, limit);

        // Type parentType = response.First().GetType();
        //Order List
        StringBuilder sortName = new StringBuilder();
        sortName.Append(sortIndex);
        sortName.Append(" ");
        sortName.Append(sortOrder.ToUpper());
        var sortedResult = response.AsQueryable<T>().SortBy<T>(sortName.ToString())
            .Skip(arguments.start)
            .Take(arguments.limit);

        //Generate Results object
        GridResult results = new GridResult();
        results.page = arguments.page.ToString();
        results.records = response.Count().ToString();
        results.total = arguments.totalPages;
        results.rows = sortedResult.ToGridRowList(idColumn, properties);

        return results;
    }

    //////////////////
    // some modifs  //
    //////////////////

    public static GridResult ToJQGridResult(this JContainer response, int page, int limit, string sortIndex, string sortOrder, string idColumn, string[] properties, Type[] types)
    {
        //Set the first column as sort order by Default
        PagingArguments arguments = GetPagingVariables(response.Count(), page, limit);

        // Type parentType = response.First().GetType();
        //Order List
        StringBuilder sortName = new StringBuilder();
        sortName.Append(sortIndex);
        sortName.Append(" ");
        sortName.Append(sortOrder.ToUpper());
        var sortedResult = response.AsQueryable()/*.SortBy(sortName.ToString())*/
            .Skip(arguments.start)
            .Take(arguments.limit);

        //Generate Results object
        GridResult results = new GridResult();
        results.page = arguments.page.ToString();
        results.records = response.Count().ToString();
        results.total = arguments.totalPages;
        results.rows = sortedResult.ToGridRowList(idColumn, properties, types);

        return results;
    }

    public static List<GridRow> ToGridRowList<T>(this IQueryable<T> source, string id, string[] properties, Type[] types)
    {
        List<GridRow> result = new List<GridRow>();

        if (source == null)
        {
            throw new ArgumentNullException("source");
        }

        if (string.IsNullOrEmpty(id))
        {
            throw new ArgumentNullException("id");
        }

        if (properties == null || properties.Length == 0)
        {
            throw new ArgumentNullException("properties");
        }

        // string test = "dafdas";
        foreach (var item in source)
        {
            try
            {
                GridRow row = new GridRow();

                JObject jobj = item as JObject;
                object rowid = jobj[id];

                row.id = rowid.ToString();
                row.cell = new string[properties.Length];

                for (int i = 0; i < properties.Length; i++)
                {
                    object obcell = jobj[properties[i]];

                    if (obcell != null)
                    {
                        switch (types[i].FullName)
                        {
                            case "System.DateTime":
                                DateTime dt;
                                DateTime.TryParse(obcell.ToString(), out dt);
                                row.cell[i] = dt.ToString();
                                break;
                            case "Syste.String":
                            default:
                                row.cell[i] = obcell.ToString();
                                break;
                        }
                    }
                    else
                        row.cell[i] = string.Empty;
                }

                result.Add(row);
            }
            catch (Exception ex)
            {
                ex.ToString();
            }
        }

        return result;
    }
}

public enum SerializerType
{
    JavaScriptSerializer = 1,
    DataContractSerializer = 2
}