<?php
/************************************************************* 
 * This script is developed by Arturs Sosins aka ar2rsawseen, http://webcodingeasy.com 
 * Feel free to distribute and modify code, but keep reference to its creator 
 * 
 * Word Solver class can generate words or anagrams using provided rules, for example,
 * possible letters, placement of specific letter, which letters should be used together,
 * or using any character from specified alphabet.
 * This class can be used to generate solutions to scrabble, crosswords, anagrams 
 * and other word games.
 * 
 * For more information, examples and online documentation visit:  
 * http://webcodingeasy.com/PHP-classes/Generate-words-from-specified-rules
**************************************************************/
class word_solver
{
	//error array
	private $errors = array();
	//current idiom
	private $idiom = "en";
	//dictionaries created for idioms, for reusing
	private $idioms = array();
	//letters from which to generate words
	private $letters = array();
	//alphabet for any character
	private $abc = array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z");
	//use all letters in words
	private $use_all = true;
	//letter reference array
	private $ref = array();
	//total letters
	private $total = 0;
	//free letters
	private $free = 0;
	//saved results
	private $result = array();
	
	/*************
	* SOME SETTERS
	**************/
	//set rules to generate words
	public function set_rules($letters){
		$arr = $this->uni_strsplit(mb_strtolower($letters));
		$together = false;
		$stick = false;
		$str = "";
		$pos = 0;
		$free = 0;
		foreach($arr as $val)
		{
			switch($val)
			{
				case "[":
					$stick = true;
					break;
				case "]":
					if($str != "")
					{
						$stick = false;
						$this->add_val($str, "stick", $pos);
						$str = "";
						$pos++;
					}
					break;
				case "(":
					$together = true;
					break;
				case ")":
					if($str != "")
					{
						$together = false;
						$this->add_val($str, "normal", $pos);
						$str = "";
						$pos++;
						$free++;
					}
					break;
				case "*":
					$this->add_val($this->abc, "array", $pos);
					$str = "";
					$pos++;
					$free++;
					break;
				default:
					if($stick || $together)
					{
						$str .= $val;
					}
					else
					{
						$this->add_val($val, "normal", $pos);
						$pos++;
						$free++;
					}
			}
		}
		$this->total = $pos;
		$this->free = $free;
	}
	
	//what idiom to use
	public function set_idiom($idiom){
		$this->idiom = $idiom;
	}
	
	//what alphabet to use
	public function set_alphabet($abc){
		$this->abc = $abc;
	}
	
	//use all letters when generating words
	public function use_all(){
		$this->use_all = true;
	}
	
	//may not use all letters when generating words
	public function not_all(){
		$this->use_all = false;
	}
	
	/*************
	* SOME GETTERS
	**************/
	
	//get errors
	public function get_errors(){
		return $this->errors;
	}
	
	//generate anagrams (contains invalid words)
	public function get_anagrams(){
		if(empty($this->letters))
		{
			$this->errors[] = 'No valid rules provided';
			return array();
		}
		else
		{
			$this->generate();
			return array_keys($this->result);
		}
	}
	
	//generate valid words
	public function get_words(){
		if(empty($this->letters))
		{
			$this->errors[] = 'No valid rules provided';
			return array();
		}
		else
		{
			$this->dictionary_init();
			$this->generate(true);
			return array_keys($this->result);
		}
	}
	
	//add letters to possible variations
	private function add_val($val, $type, $pos){
		$cnt = sizeof($this->letters);
		$correct = false;
		if($type != "stick" && in_array($val, $this->ref))
		{
			$key = array_keys($this->ref, $val);
			foreach($key as $v)
			{
				if(isset($this->letters[$v]) && $this->letters[$v]["type"] == $type)
				{
					$this->letters[$v]["cnt"]++;
					$correct = true;
				}
			}
		}
		if(!$correct || $type == "stick")
		{
			$cnt = sizeof($this->letters);
			$new = array();
			$new["value"] = $val;
			$new["type"] = $type;
			if($new["type"] =="array")
			{
				$new["select"] = 0;
			}
			$new["cnt"] = 1;
			$new["position"] = $pos;
			$this->letters[$cnt] = $new;
			$this->ref[$cnt] = $val;
		}
	}
	
	//generate words
	//Recursive method is too slow 
	//and requires alot more of memory
	//so we do it old fashioned way
	private function generate($spell = false){
		$word = array_fill(0, $this->total, 0);
		$stick = array();
		$masivi = array();
		$l = 0;
		$m = $this->total -1;
		$str = "";

		$stack = array();
		$stack[] = 0;
		$stack_pointer = 1;
		
		$min_length = 1;
		foreach($this->letters as $val)
		{
			if($val["type"] == "stick")
			{
				$stick[$val["position"]] = $val["value"];
				$min_length = $val["position"]+1;
			}
			else if($val["type"] == "array")
			{
				$masivi[$val["position"]] = $val["value"];
			}
		}
		$free_size = sizeof($this->letters);
		
		while($l >= 0)
		{
			if(!isset($stick[$l] )) // if not sticky letter
			{
				while(isset($this->letters[$word[$l]]) && ($this->letters[$word[$l]]["cnt"] == 0 || isset($stick[$word[$l]] )))
				{
					$word[$l]++;
				}
				
			}
			if($word[$l] >= $free_size)//last index
			{
				//Backtracking;
				if(!$this->use_all && ($l >=$min_length))//may not use all letters
				{
					if(!$spell || ($spell && $this->dictionary_check($str)))//annagrams or valid words
					{
						$this->result[$str] = true;
					}
				}
				$stack_pointer--; //pop out from stack
				$this->letters[$stack[$stack_pointer]]["cnt"]++;
				if(isset($masivi[$stack[$stack_pointer]]))
				{
					$p = $this->letters[$stack[$stack_pointer]]["select"]-1;
					$str = substr($str, 0, strlen($str)-1);
				}
				else
				{
					if($this->letters[$stack[$stack_pointer]]["type"]=="array")
					{
						$str = substr($str, 0, strlen($str)-1);
					}
					else
					{
					$str = substr($str, 0, strlen($str)-strlen($this->letters[$stack[$stack_pointer]]["value"]));//no&#326;em p&#275;d
					}
				}
				$word[$l] = 0; //0 level
				
				$l--; //previous letter
			}
			elseif($l == $m)//if in last position
			{

				if(strlen($str) >= $min_length)
				{
					if(!$this->use_all)
					{
						if(!$spell || ($spell && $this->dictionary_check($str)))
						{
							$this->result[$str] = true;
						}
					}
					if(isset($stick[$l]))
					{
						//last letter sticky
						if(!$spell || ($spell && $this->dictionary_check($str.($this->letters[$l]["value"]))))
						{
							$this->result[$str.($this->letters[$l]["value"])] = true;
						}
					}
					else
					{	
						if($spell)
						{
							for($i = 0; $i < $free_size; $i++)
							{
								if($this->letters[$i]["cnt"] > 0)
								{
									if($this->letters[$i]["type"]=="array")
									{
										for($p=0; $p<sizeof($this->letters[$i]["value"]); $p++)
										{
											$k = $str.$this->letters[$i]["value"][$p];
											if($this->dictionary_check($k))
											{
												$this->result[$k] = true;
											}
										}
									}
									else//normal
									{
										$k = $str.$this->letters[$i]["value"];
										if($this->dictionary_check($k))
										{
											$this->result[$k] = true;
										}
									}
								}
							}
						}
						else
						{
							for($i = 0; $i < $free_size; $i++)
							{
								if($this->letters[$i]["cnt"] > 0)
								{
									if(isset($masivi[$i]))
									{
										for($p=0; $p<sizeof($this->letters[$i]["value"]); $p++)
										{
											$this->result[$str.$this->letters[$i]["value"][$p]] = true;
										}
									}
									else
									{
										$this->result[$str.$this->letters[$i]["value"][$p]] = true;
									}
								}
							}
						}	
					}
				}
				
				$stack_pointer--; //pop out of stack
				$this->letters[$stack[$stack_pointer]]["cnt"]++;
				if(isset($masivi[$stack[$stack_pointer]]))
				{
					$p = $this->letters[$stack[$stack_pointer]]["select"]-1;
					$str = substr($str, 0, strlen($str)-1);
				}
				else
				{
				if($this->letters[$stack[$stack_pointer]]["type"]=="array")
					{
						$str = substr($str, 0, strlen($str)-1);
					}
					else
					{
					$str = substr($str, 0, strlen($str)-strlen($this->letters[$stack[$stack_pointer]]["value"]));//no&#326;em p&#275;d
					}
				}
				$word[$l]=0;
				$l--;				
			}
			else
			{
				if(isset($stick[$l]))
				{
					//add sticky letter
					$word[$l] = $free_size;
					if(!$spell || $this->dictionary_test($str.$this->letters[$l]["value"]))//should we continue to generate this word
					{
						$str .= $this->letters[$l]["value"];
						$stack[$stack_pointer] = $l;
						
						$stack_pointer++;
						$this->letters[$l]["cnt"]--;
						$l++;
						$word[$l] = 0;
					}
					
					
				}
				else if($this->letters[$word[$l]]["type"]=="array")
				{
					//should we continue to generate this word
					if(!$spell || $this->dictionary_test($str.$this->letters[$word[$l]]["value"][$this->letters[$word[$l]]["select"]]))
					{
						$str .= $this->letters[$word[$l]]["value"][$this->letters[$word[$l]]["select"]];
						$stack[$stack_pointer] = $word[$l];
						$stack_pointer++;
						$this->letters[$word[$l]]["select"]++;
						$this->letters[$word[$l]]["cnt"]--;
						if($this->letters[$word[$l]]["select"] >= sizeof($this->letters[$word[$l]]["value"]))
						{
							$this->letters[$word[$l]]["select"] = 0;
							$word[$l]++;
						}
						$l++;
						$word[$l] = 0;
					}
					else
					{
						$this->letters[$word[$l]]["select"]++;
						if($this->letters[$word[$l]]["select"] >= sizeof($this->letters[$word[$l]]["value"]))
						{
							$this->letters[$word[$l]]["select"] = 0;
							$word[$l]++;
						}
					}
				}
				else
				{
					
					if(!$spell || $this->dictionary_test($str.$this->letters[$word[$l]]["value"]))//should we continue to generate this word
					{
						$str .= $this->letters[$word[$l]]["value"];
						$stack[$stack_pointer] = $word[$l];
						$stack_pointer++;
						$this->letters[$word[$l]]["cnt"]--;
						$word[$l]++;
						$l++;
						$word[$l] = 0;
					}
					else
					{
						$word[$l]++;
					}
				}
			}
		}
	}
	
	//split unicode strings
	private function uni_strsplit($string, $split_length=1){
		preg_match_all('`.`u', $string, $arr);
		$arr = array_chunk($arr[0], $split_length);
		$arr = array_map('implode', $arr);
		return $arr;
	}
	
	/**********************
	* DICTIONARY FUNCTIONS
	**********************/
	
	//initialize dictionary (for $this->idiom)
	protected function dictionary_init(){
		if(function_exists("pspell_new"))
		{
			if(!isset($this->idioms[$this->idiom]))
			{
				try{
					$this->idioms[$this->idiom] = pspell_new($this->idiom, "", "", "", PSPELL_FAST);
				}
				catch(Exception $e)
				{
					$this->errors[] = 'Caught exception: '.$e->getMessage().". Probably illegal idiom";
				}
			}
		}
		else
		{
			$this->errors[] = "Pspell isn't enabled. Please enable pspell or use get_anagram method";
		}
	}
	
	/********************************************************
	* in this function we can check if we use provided string as a start,
	* is there a possibility to generate a valid word
	* return true if yes and false if no
	* As we don't have this option in PSpell, 
	* we simply return true to every input
	* but when using custom dictionaries, you may want to override
	* this function with your implementation to increase performance of the class
	********************************************************/
	protected function dictionary_test($string){
		$ret = true;
		return $ret;
	}
	
	//return false if word is incorrect
	//or true if word is correct
	protected function dictionary_check($word){
		$ret = false;
		if(isset($this->idioms[$this->idiom]))
		{
			$ret = pspell_check($this->idioms[$this->idiom],$word);
		}
		else
		{
			$this->errors[] = "Dictionary isn't initialized";
		}
		return $ret;
	}
	
}
?>