<?php
/************************************************************* 
 * This script is developed by Arturs Sosins aka ar2rsawseen, http://webcodingeasy.com 
 * Feel free to distribute and modify code, but keep reference to its creator 
 * 
 * Word Solver class can generate words or anagrams using provided rules, for example,
 * possible letters, placement of specific letter, which letters should be used together,
 * or using any character from specified alphabet.
 * This class can be used to generate solutions to scrabble, crosswords, anagrams 
 * and other word games.
 * 
 * For more information, examples and online documentation visit:  
 * http://webcodingeasy.com/PHP-classes/Generate-words-from-specified-rules
**************************************************************/
include("./word_solver.php");
//extending
class custom_word_solver extends word_solver 
{ 
	/**************************** 
	* CUSTOM DICTIONARY FUNCTIONS 
	****************************/ 
	
	//initialize dictionary 
	protected function dictionary_init(){ 
		$str = file_get_contents("./custom_dictionary.txt"); 
		$parts = explode("\r\n", $str); 
		foreach($parts as $part) 
		{ 
			$this->dict[mb_strtolower($part)] = true; 
		} 
	} 
	
	//return false if word is incorrect 
	//or true if word is correct 
	protected function dictionary_check($word){ 
		$ret = false; 
		if(strlen($word) > 2) 
		{ 
			if(isset($this->dict[$word])) 
			{ 
				$ret = true; 
			} 
		} 
		return $ret; 
	} 
 } 
?>