<?php
/************************************************************* 
 * This script is developed by Arturs Sosins aka ar2rsawseen, http://webcodingeasy.com 
 * Feel free to distribute and modify code, but keep reference to its creator 
 * 
 * Word Solver class can generate words or anagrams using provided rules, for example,
 * possible letters, placement of specific letter, which letters should be used together,
 * or using any character from specified alphabet.
 * This class can be used to generate solutions to scrabble, crosswords, anagrams 
 * and other word games.
 * 
 * For more information, examples and online documentation visit:  
 * http://webcodingeasy.com/PHP-classes/Generate-words-from-specified-rules
**************************************************************/

//it can take some time
set_time_limit(0); 
$time = microtime();
$time = explode(' ', $time);
$start = $time[1] + $time[0];
?>
<form method='post' action=''>
<p>Rules: <input type='text' name='rules' value='a(cl)s[s]*e'/></p>
<p>Use all letters: <select name='use_all'>
<option value='true'>Yes</option>
<option value='false'>No</option>
</select></p>
<p>Return: <select name='type'>
<option value='words'>Valid words</option>
<option value='anagrams'>Anagrams</option>
</select></p>
<p><input type='submit' value='Generate'/></p>
</form>
<?php
if(isset($_POST["rules"]) && trim($_POST["rules"]) != "")
{
	//declaring class instance
	include("./custom_word_solver.php");
	 //use custom class as you would use original word_solver
	$ws = new custom_word_solver();

	if(isset($_POST["use_all"]) && $_POST["use_all"] == "false")
	{
		//use all provided letters
		$ws->not_all();
	}

	//setting rules for words
	$ws->set_rules($_POST["rules"]);

	//getting results
	if(isset($_POST["type"]) && $_POST["type"] == "anagrams")
	{
		$arr = $ws->get_anagrams();
	}
	else
	{
		$arr = $ws->get_words();
	}
	$errors = $ws->get_errors();
	if(!empty($errors))
	{
		echo "<p>Errors:</p>";
		echo "<pre>";
		print_r($errors);
		echo "</pre>";
	}
	echo "<pre>";
	print_r($arr);
	echo "</pre>";
}
$time = microtime();
$time = explode(' ', $time);
$end = $time[1] + $time[0];
$total_time = round(($end - $start), 4);
echo '<p>PHP execution: '.$total_time.' seconds.</p>';
?>
