<?php

require_once('fpv.class.php');

// MAP MATRIX
$map[0][1][0] = "1-0.jpg";
$map[0][1][90] = "1-90.jpg";
$map[0][1][180] = "1-180.jpg";
$map[0][1][270] = "1-270.jpg";
$map[1][1][0] = "2-0.jpg";
$map[1][1][90] = "2-90.jpg";
$map[1][1][180] = "2-180.jpg";
$map[1][1][270] = "2-270.jpg";
$map[1][0][0] = "3-0.jpg";
$map[1][0][90] = "3-90.jpg";
$map[1][0][180] = "3-180.jpg";
$map[1][0][270] = "3-270.jpg";
$map[1][2][0] = "4-0.jpg";
$map[1][2][90] = "4-90.jpg";
$map[1][2][180] = "4-180.jpg";
$map[1][2][270] = "4-270.jpg";

if (isset($_POST["current_angle"])) {
    $fpv = new firstPersonView($map, $_POST["current_x"], $_POST["current_y"], $_POST["current_angle"], "images");
} else {
    $fpv = new firstPersonView($map, 0, 1, 0, "images");
}

if($_POST['go-forward']) {
    $fpv->goForward();
} else if($_POST['go-back']) {
    $fpv->goBack();
} else if($_POST['go-left']) {
    $fpv->goLeft();
} else if($_POST['go-right']) {
    $fpv->goRight();
} else if($_POST['turn-right']) {
    $fpv->turnRight();
} else if($_POST['turn-left']) {
    $fpv->turnLeft();
}

?>
<html>
    <head>
        <title>First Person View Class - Example</title>
    </head>
    <body>
        <p>Please go to
            <a href="http://oscardias.com/php/php-class-first-person-view/">http://oscardias.com/php/php-class-first-person-view/</a>
            if ou need more info.
        </p>
        <form name="movements" action="example.php" method="post">
            <input type="submit" name="turn-left" value="Turn Left" <?php echo ($fpv->checkTurnLeft())?"":"disabled"; ?>/>
            <input type="submit" name="go-left" value="Move Left" <?php echo ($fpv->checkLeft())?"":"disabled"; ?>/>
            <input type="submit" name="go-forward" value="Move Forward" <?php echo ($fpv->checkForward())?"":"disabled"; ?>/>
            <input type="submit" name="go-back" value="Move Back" <?php echo ($fpv->checkBack())?"":"disabled"; ?>/>
            <input type="submit" name="go-right" value="Move Right" <?php echo ($fpv->checkRight())?"":"disabled"; ?>/>
            <input type="submit" name="turn-right" value="Turn Right" <?php echo ($fpv->checkTurnRight())?"":"disabled"; ?>/>
            <!-- BEGIN IMPORTANT HIDDEN INFO -->
            <input type="hidden" name="current_x" value="<?php echo $fpv->currentX; ?>" />
            <input type="hidden" name="current_y" value="<?php echo $fpv->currentY; ?>" />
            <input type="hidden" name="current_angle" value="<?php echo $fpv->currentAngle; ?>" />
            <!-- END IMPORTANT HIDDEN INFO -->
        </form>
        <img id="view" src="<?php $fpv->currentView() ?>" />
    </body>
</html>
