<?php
//!--------------------------------------------------------
// @class		contentLeecher
// @desc		Filtra e retorna o contedo de um source
//				de acordo com a expresso regular ou intervalo
//				especificado. Faz strip em tags especficas ou
//				em tags de intervalo. Possui tambm um mtodo
//				para fazer strip em tags, com excesses definidas.
// @author		Leandro Palmieri (lpalmieri@terra.com.br)
// @version		Version: 1.3 / Revision: $
//!--------------------------------------------------------
class contentLeecher {

	var $dataSource	= NULL;				// @var dataSource			string	Url ou arquivo de dados
	var $stringSource = NULL;			// @var stringSource		string	String de entrada de dados
	var $regularExpression = NULL;		// @var regularExpression	string  Expresso regular para match
	var $saveTags = NULL;				// @var saveTags			string  Tags a ignorar no stripTags
	var $interval = NULL;				// @var interval			string  Intervalos, por separador
	var $stripStr = NULL;				// @var stripStr			array	Strings extras a fazer strip
	var $stripTags = FALSE;				// @var stripTags			bool    Ativa ou desativa o stripTags
	var $stripJavaScript = TRUE;		// @var stripJavaScript		bool    Ativa ou desativa o striptag JS
	var $removeInterval = FALSE;		// @var removeInterval		bool	Strip nas strings de intervalo
	var $intervalSeparator = '|';		// @var intervalSeparator	string  String separadora do interval
	var $_outArray;

	//!--------------------------------------------------------
	// @function	contentLeecher::contentLeecher
	// @desc		Construtor da classe
	// @access		public
	// @return		bool
	//!--------------------------------------------------------
	function contentLeecher() {
		if (!$this->dataSource)
			return FALSE;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::_contentLeecher
	// @desc		Destrutor da classe
	// @access		public
	// @return		bool
	//!--------------------------------------------------------
	function _contentLeecher() {
		unset($this);
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::dataSource
	// @desc		Define a Url ou arquivo de entrada de dados
	// @param		source	Arquivo ou Url de entrada
	// @access		public
	// @note		Ao setar um dataSource, o stringSource  anulado
	// @return		void
	//!--------------------------------------------------------
	function dataSource($source) {
		if ($source) {
			$this->dataSource = $source;
			unset($this->stringSource);
		}
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::stringSource
	// @desc		Define uma string de entrada de dados
	// @param		source	Arquivo ou Url de entrada
	// @access		public
	// @note		Ao setar uma string, o dataSource  anulado
	// @return		void
	//!--------------------------------------------------------
	function stringSource($source) {
		if ($source) {
			$this->stringSource = $source;
			unset($this->dataSource);
		}
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::execute
	// @desc		Trata o source e executa mtodos de filtros
	// @access		public
	// @return		string	Dados filtrados, ou false em caso de erro
	//!--------------------------------------------------------
	function execute() {
		if ($srcData = $this->dataSource ? @file_get_contents($this->dataSource) : $this->stringSource) {
			$dataResult = $this->regularExpression || $this->interval ? $this->doFilter($srcData) : $srcData;
			if (!is_array($dataResult))
				$result[] = $dataResult;
			else
				$result = $dataResult;
			return $result[0];
		}
		return FALSE;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::displayData
	// @desc		Executa mtodo de tratamento do source e exibe
	// @access		public
	// @return		void
	//!--------------------------------------------------------
	function displayData() {
		if ($outData = $this->execute())
			print($outData);
		else
			print('displayData(): nothing to display');
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::doFilter
	// @desc		Executa a expresso regular ou intervalo definido
	// @param		readLine	Linha de entrada para tratamento
	// @access		public
	// @return		array		Linha tratada com filtros
	//!--------------------------------------------------------
	function doFilter($source) {
		if (!$this->regularExpression && $this->interval) {
			$intervalBroken = explode($this->intervalSeparator, $this->interval);
			$this->regularExpression = $intervalBroken[0] . '(.*.)' . $intervalBroken[1];
		} elseif (!$this->regularExpression && !$this->interval) {
			return FALSE;
		}
		if (@eregi($this->regularExpression, $source, $out)) {
			foreach($out as $outArray) {
				$this->_outArray[] = $this->_stripStr($this->_removeInterval($this->_stripTags($this->_stripJavaScript($outArray))));
			}
			return $this->_outArray;
		}
		return FALSE;
	}
	//!--------------------------------------------------------
	// @function	contentLeecher::_stripTags
	// @desc		Faz um strip nas tags de html, se o flag for setado
	// @param		lineData	Linha de dados sem strip
	// @access		private
	// @return		string	linha sem tags
	//!--------------------------------------------------------
	function _stripTags($lineData) {
		$lineData = $this->stripTags ? strip_tags($lineData, $this->saveTags) : $lineData;
		return $lineData;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::_removeInterval
	// @desc		Faz um strip nas tags de html, se o flag for setado
	// @param		lineData	Linha de dados sem strip
	// @access		private
	// @return		string	linha sem tags de intervalo
	//!--------------------------------------------------------
	function _removeInterval($lineData) {
		if ($this->interval) {
			$intervalBroken = explode($this->intervalSeparator, $this->interval);
			$lineData = $this->removeInterval ? str_replace($intervalBroken[0], NULL, str_replace($intervalBroken[1], NULL, $lineData)) : $lineData;
		}
		return $lineData;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::_stripStr
	// @desc		Faz um strip nas strings especificadas
	// @param		lineData	Linha de dados sem strip
	// @access		private
	// @return		string	linha sem tags de intervalo
	//!--------------------------------------------------------
	function _stripStr($lineData) {
		if (is_array($this->stripStr) && sizeof($this->stripStr)) {
			foreach($this->stripStr as $stripString)
				$lineData = str_replace($stripString, NULL, $lineData);
		}
		return $lineData;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::_stripJavaScript
	// @desc		Define o texto para fazer strip de tags de JS
	// @param		dataIn	string texto
	// @access		public
	// @return		void
	//!--------------------------------------------------------
	function _stripJavaScript($lineData) {
		if ($this->stripJavaScript)
			$lineData = eregi_replace('<script(.*.)</script>', '', $lineData);
		return $lineData;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::regularExpression
	// @desc		Define a expresso regular
	// @param		dataIn	string expresso
	// @access		public
	// @return		void
	//!--------------------------------------------------------
	function regularExpression($dataIn) {
		$this->regularExpression = $dataIn;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::saveTags
	// @desc		Define as tags a ignorar no caso de striptags
	// @param		dataIn	string tags
	// @access		public
	// @note		Utilizar no formato <a><b><u> ...
	// @return		void
	//!--------------------------------------------------------
	function saveTags($dataIn) {
		$this->saveTags = $dataIn;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::interval
	// @desc		Define os strings de limite inicio/fim para filtro de texto
	// @param		dataIn	string intervalo inicio {separador} intervalo fim
	// @access		public
	// @note		Utilizar no formato 'StringInicial{separador}StringFinal'
	// @return		void
	//!--------------------------------------------------------
	function interval($dataIn) {
		$this->interval = $dataIn;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::stripStr
	// @desc		Define o texto para fazer strip da string
	// @param		dataIn	string texto
	// @access		public
	// @return		void
	//!--------------------------------------------------------
	function stripStr($dataIn) {
		$this->stripStr[] = $dataIn;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::stripTags
	// @desc		Define TRUE ou FALSE para stripTags
	// @param		boolDefine	bool
	// @access		public
	// @return		void
	//!--------------------------------------------------------
	function stripTags($boolDefine) {
		$this->stripTags = $boolDefine;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::stripJavaScript
	// @desc		Define TRUE ou FALSE para strip de cdigos em tags JS
	// @param		boolDefine	bool
	// @access		public
	// @return		void
	//!--------------------------------------------------------
	function stripJavaScript($boolDefine) {
		$this->stripJavaScript = $boolDefine;
	}

	//!--------------------------------------------------------
	// @function	contentLeecher::removeInterval
	// @desc		Define TRUE ou FALSE para remover as strings de intervalo
	// @param		boolDefine	bool
	// @access		public
	// @return		void
	//!--------------------------------------------------------
	function removeInterval($boolDefine) {
		$this->removeInterval = $boolDefine;
	}

}
?>