<?
/*
Tipo : classe
Nome : UpLoad
Data : 29/08/2003
Autor: Wonder Alexandre Luz Alves
Desc : esta class faz upload de arquivo gera uma mini imagem p/ visualizao e tem tratamento de erros
Verso: 1.2
*/


class UpLoad
{
	
	var $arquivo_permissao;	
	var $dir;		
	var $max_filesize;		
	var $idioma;	
	var $error=0;
	var $file_type;
	var $file_name;
	var $file_size;
	var $arquivo;
	var $file_path;
	var $warning=0;	
	var $MINI_name;
	var $MINI_path="images_mini";
	
	function UpLoad ($permissao="" , $max_file = 300000, $dir = "images",$idioma="portugues"){
		if ( empty ($permissao) ) $permissao = array ("image/pjpeg","image/x-png","image/jpeg","image/png","image/gif");
		$this->arquivo_permissao = $permissao; 
		$this->max_filesize = $max_file;
		$this->dir = $dir;
		$this->idioma = $idioma;
	}
	
	function putFile ($file){
		$this->file_type = strtok ( $_FILES[$file]['type'], ";"); 
		$this->file_name = $_FILES[$file]['name']; 
		$this->file_size = $_FILES[$file]['size']; 
		$this->temp = $_FILES[$file]['tmp_name'];  // upload para o diretorio temp
		
		if(!in_array($this->file_type, $this->arquivo_permissao))
			$this->Error(1);
		
        if ( ($this->file_size <= 0) || ($this->file_size > $this->max_filesize) ) $this->Error(2);
		
        if ($this->error == ""){
			$filename = basename ($this->file_name); 
            if (!empty ($this->dir) ) 
				$this->arquivo = $this->dir."/".$filename;
			else 
				$this->arquivo = $filename; 

			if (file_exists($this->arquivo)){
            	srand((double)microtime()*1000000);
            	$filename = rand(0,20000).$filename; 
            	if (!empty ($this->dir)) 
					$this->arquivo = $this->dir."/".$filename;
				else 
					$this->arquivo = $filename;
            }
			
			if(!is_uploaded_file($this->temp)) $this->Error(3);
			if(!@move_uploaded_file($this->temp,$this->arquivo) ) $this->Error(4);
			
			return $this->arquivo;
		}
		else {
			return false;
        }

	}
	
	function checar_gd()
	{
		$testGD = get_extension_funcs("gd"); 
		if (!$testGD) 
			$this->error(5);
		else{
			ob_start(); 
			phpinfo(8); 
			$grab = ob_get_contents(); 
			ob_end_clean(); 
			$version = strpos  ($grab,"2.0 or higher"); 
			if ( $version ) return "gd2"; 
			else return "gd"; 
		}
	}	
	
	function Gerar_mini($new_image_file_path, $max_width=480, $max_height=1600 )
	{
    	$return_val = 1;
    	if(eregi("\.png$",$this->arquivo)){
			$return_val = ( ($img = ImageCreateFromPNG ( $this->arquivo )) && $return_val == 1 ) ? "1" : "0";
    	}
    	if(eregi("\.(jpg|jpeg)$",$this->arquivo)){
    		$return_val = ( ($img = ImageCreateFromJPEG ( $this->arquivo )) && $return_val == 1 ) ? "1" : "0";
    	}
	  	if(eregi("\.gif$",$this->arquivo)){
    		$return_val = ( ($img = ImageCreateFromGif ( $this->arquivo )) && $return_val == 1 ) ? "1" : "0";
    	}

    	$FullImage_width = imagesx ($img);    
    	$FullImage_height = imagesy ($img);   

    	$ratio =  ( $FullImage_width > $max_width ) ? (real)($max_width / $FullImage_width) : 1 ;
    	$new_width = ((int)($FullImage_width * $ratio));    //full-size width
    	$new_height = ((int)($FullImage_height * $ratio));    //full-size height
    	
    	$ratio =  ( $new_height > $max_height ) ? (real)($max_height / $new_height) : 1 ;
    	$new_width = ((int)($new_width * $ratio));    //mid-size width
    	$new_height = ((int)($new_height * $ratio));    //mid-size height

    	if ( $new_width == $FullImage_width && $new_height == $FullImage_height ) copy ( $this->arquivo, $new_image_file_path );
		$gd_version = $this->checar_gd();
		if ( $gd_version == "gd2" ) {		
    		$full_id =  ImageCreateTrueColor ( $new_width , $new_height ); //Crea un'immagine
    		ImageCopyResampled ( $full_id, $img, 0,0,0,0, $new_width, $new_height, $FullImage_width, $FullImage_height );
		}
		elseif ( $gd_version == "gd" ){		
    		$full_id = ImageCreate ( $new_width , $new_height ); //Crea un'immagine
    		ImageCopyResized ( $full_id, $img, 0,0,0,0, $new_width, $new_height, $FullImage_width, $FullImage_height );
		}
		else $this->Error(5);
		
    	if(eregi("\.(jpg|jpeg)$",$this->arquivo)){
    		$return_val = ( $full = ImageJPEG( $full_id, $new_image_file_path, 80 ) && $return_val == 1 ) ? "1" : "0";
    	}
    	if(eregi("\.png$",$this->arquivo)) 	{
			$return_val = ( $full = ImagePNG( $full_id, $new_image_file_path ) && $return_val == 1 ) ? "1" : "0";
    	}
		if(eregi("\.gif$",$this->arquivo)) 	{
			if($gd_version != "gd2")
				return 0;
			$return_val = ( $full = imagegif($full_id, $new_image_file_path) && $return_val == 1 ) ? "1" : "0";
    	}

    	ImageDestroy( $full_id );
    	return ($return_val) ? TRUE : FALSE ;

	}
				
	function Miniatura($larg=80, $alt=80, $pre_name="MINI_"){
		if ((eregi("\.png$", $this->arquivo) || eregi("\.(jpg|jpeg)$", $this->arquivo) || eregi("\.gif$", $this->arquivo)) && $this->arquivo){
			$this->MINI_name = $pre_name . $this->file_name;
			if (!empty ($this->MINI_path)) 
				$thumb_path =  $this->MINI_path ."/". $pre_name . $this->file_name;
			else 
				$thumb_path = $pre_name . $this->file_name;
            if ($this->Gerar_mini($thumb_path, $larg, $alt)) 
            	return $thumb_path;
			else{ 
				$this->Warning(1);
				return 0;
			}
		}
        else $this->Warning(2);
		
	}
	
	function Error($op){
		if($this->idioma="portugues"){
			switch ($op){
				case 0: return; break;
				case 1: $this->error = "Error 1: Este tipo de arquivo no tem permisso para upload : $this->file_type."; break;
				case 2: $this->error = "Error 2: Erro no tamanho do arquivo: $this->file_size Kb. Tamanho Maximo  $this->max_filesize."; break;
				case 3: $this->error = "Error 3: Ocorreu um erro na transferencia do arquivo: $this->file_name."; break;
				case 4: $this->error = "Error 4: Ocorreu um erro na transferencia de $this->temp para $this->file_name."; break;
				case 5: $this->error = "Error 5: Biblioteca GD no instalada!";break; 
			}
		}
		
	   	?> <SCRIPT> alert("<?= $this->error; ?>"); </SCRIPT> <?
	   exit;
	}
	
	function Warning($op){
		if($this->idioma="portugues"){
			switch ($op){
				case 1: $this->warning = "Aviso 1: Ocorreu um erro na criao da Miniatura.";break;
				case 2: $this->warning = "Aviso 2: Esse arquivo no tem Miniatuara"; break;
			}
		}
		?> <SCRIPT> alert("<?= $this->warning; ?>"); </SCRIPT> <?
	   
	}
	function Mostrar_MINI($tipo='1'){
		if(file_exists($this->MINI_path . "/" . $this->MINI_name))
			$url = "<img src=" . $this->MINI_path . "/" . $this->MINI_name . " name=x>";
		else 	
			$url = "<center>No H Amostra!</center>";
		if($tipo==2) return $url;
		?>
		<script>
		  WIN = window.open ('', 'NINIatura', 'toolbar=no,width=90,height=90,directories=no,status=no,scrollbars=no,resize=no,menubar=no');
		  WIN.document.write("<? echo $url ?>");
		</script>
 		<?
	
	}
					
}
?>

		