<?php
/**
 * Created on Jun 29, 2006<br />
 * Project CiulImages<br />
 * File name CiulCaptcha.php<br />
 * Author nk913<br />
 * @package Ciul
 * @access public
 */
 
 define('DEFAULT_BG_IMG', 'backgrounds'.DIRECTORY_SEPARATOR.'blond.jpg');
 define('DEFAULT_FONT', 'fonts'.DIRECTORY_SEPARATOR.'Air.ttf');
 define('DEFAULT_COLOR', 0);
 define('DEFAULT_SIZE', 40);
 
 class CiulCaptcha{
	/**
	 * Background image resource
	 * @access private
	 * @var resource 
	 */
 	var $image;
 	/**
 	 * Font location
 	 * @access private
 	 * @var string
 	 */
 	var $font;
 	/**
 	 * Randoming font size
 	 * @access private
 	 * @var boolean
 	 */
 	var $randomizeSize;
 	/**
 	 * Randoming font color
 	 * @access private
 	 * @var boolean
 	 */
 	var $randomizeColor;
 	/**
 	 * Angle in degre
 	 * @access private
 	 * @var int
 	 */
 	var $angle;
 	
 	/**
 	 * CiulCaptcha constructor
 	 * @param string relative or fullpath of background image (jpeg) 
 	 * @param string relative or fullpath of font
 	 * @param int font degree
 	 * @param boolean randomize font size
 	 * @param boolean randomize font color
 	 */
 	function CiulCaptcha($bgImg, $fontName= DEFAULT_FONT, $angle= 0, $randomizeSize= TRUE, $randomizeColor= TRUE){
 		(isset($bgImg))? $this->image= @imagecreatefromjpeg($bgImg):$this->image= @imagecreatefromjpeg(DEFAULT_BG_IMG); 
 		(isset($fontName))? $this->font= $fontName:$this->font= DEFAULT_FONT;
 		$this->font= $fontName;
 		$this->angle= $angle;
 		$this->randomizeSize= $randomizeSize;
 		$this->randomizeColor= $randomizeColor;
  	}
  	/**
  	 * Randomize some color
  	 * @param int Index of current color array, use to got the rgb
  	 * @return int rgb integer
  	 * @access private
  	 */
  	function randColor($index){
  		if($this->randomizeColor){
  			$rgb= array(0,25,50,75,100,125,150,175,200,225);
 			shuffle($rgb);
 			return $rgb[$index];
  		} else {
  			return(DEFAULT_COLOR);
  		}
  	}
  	/**
  	 * Randomize font size
  	 * @return int font size
  	 * @access private
  	 */
  	function randSize(){
  		if($this->randomizeSize){
  			$size= array(30,40,50);
 			shuffle($size);
 			return $size[0];
  		} else {
  			return(DEFAULT_SIZE);
  		}
  	}
  	/**
  	 * Add text to the image
  	 * @param string text to added
  	 * @return void
  	 * @access public
  	 */
 	function addText($text){
 		for($i= 0; $i< strlen($text);$i++){
 			$color= @imagecolorallocate($this->image, $this->randColor(0), $this->randColor(1), $this->randColor(2));
 			@imagettftext($this->image,$this->randSize(),$this->angle,(($i + 1) * DEFAULT_SIZE),(DEFAULT_SIZE * 1.5), $color, $this->font, $text{$i});	
 		} 	
 	} 
 	/**
 	 * Display the image
 	 * @return resource image resource
 	 * @access public
 	 */
 	function getImage(){
 		return $this->image;
 	}
}
?>
