<?
include('phpmorph.php');

class phpmaze {

    var $version = '1.1 light';
    var $copyright = '// Protected by Solace Script Maze 1.1 light (c) Zilav, 2003-2004';
    var $file_src = '';
    var $file_dst = '';
    var $file_tmp = 'phpmaze.tmp';
    var $content_src = '';
    var $table = '';
    var $log = '';
    var $turck_encoded_src = '';
    var $maze_level = 5;
    var $morph_level = 2;
    var $tpl = array();
    var $tpl_names = array();
    var $options = array();
    var $morpher = 0;
    var $current_maze_level = 0;
    var $trace = array();
    var $content = '';
    
    //=========================================================
    function phpmaze() {
        set_time_limit(0);
        srand(time());
        $this->load_enc_templates('encodelib/');
        $this->morpher = new phpmorph;
        for ($i=0; $i<=255; $i++) $this->table .= chr($i);
        $o = &$this->options;
        $o['log'] = 1;
        $o['phpversion'] = '4.3.0';
        $o['overwrite'] = 1;
        $o['compress']['enable'] = 1;
        $o['compress']['level'] = 9;
        $o['self_crc'] = 1;
        $o['password'] = '';
        $o['expire']['enable'] = 0;
        $o['expire']['year'] = 2003;
        $o['expire']['month'] = 11;
        $o['expire']['day'] = 5;
        $o['expire']['hour'] = 19;
        $o['expire']['minute'] = 54;
        $o['allowed']['client_ip'] = '';
        $o['allowed']['host_ip'] = '';
        $o['turck'] = 0;
    }

    //=========================================================
    function to_log($msg) {
        if ($this->options['log']) {
            echo "$msg\n"; flush();
            ob_flush();
        } else
            $this->log .= $msg."\n";
    }

    //=========================================================
    function file_load($fn) {
        return file_get_contents($fn);
    }
    
    //=========================================================
    function file_save($fn, $txt) {
        if ($fn == '') {
            $this->content = $txt;
            return true;
        }
        if (($f = @fopen($fn, 'wb')) !== false) {
            fwrite($f, $txt);
            fclose($f);
            return true;
        } else {
            return false;
        }
    }
    
    //=========================================================
    function load_enc_templates($path) {
        $d = dir($path); 
        while (($fn = $d->read()) !== false) { 
            if (!is_file($path.$fn)) continue;
            $name = substr($fn, 0, strpos($fn, '.'));
            $tpl = $this->file_load($path.$fn);
            preg_match("/\/\/\s*#Encoder(.+?)\/\/ #Decoder/is", $tpl, $regs);
            $code_enc = $regs[1];
            $code_enc = preg_replace("/\/\/.*?[\r\n]+/s", '', $code_enc);
            preg_match("/\/\/\s*#Decoder(.+)/is", $tpl, $regs);
            $code_dec = $regs[1];
            if (preg_match("/\/\/\s*#PHP version\s*(.+)\s*/is", $tpl, $regs)) $php_version = $regs[1];
                else $php_version = '4.3.0';
            $code_dec = preg_replace("/\/\/.*?[\r\n]+/s", '', $code_dec);
            $this->tpl[$name] = array (
                'php_version' => trim($php_version),
                'code_enc' => trim($code_enc),
                'code_dec' => trim($code_dec)
            );
            if ($name[0] <> '_') $this->tpl_names[] = $name;
        } 
        $d->close(); 
    }

    //=========================================================
    function php_explode(&$str) {
        $a = preg_split("/(<\?php|<\?|\?>|<\%|\%>)/i", $str);
        return $a;
    }

    //=========================================================
    function php_implode(&$php_array) {
        $po = '<'.'?';
        $pc = '?'.'>';
        $i = 0;
        $s = $pc;
        foreach ($php_array as $id => $block) {
            if ($i%2) $s .= $po;
            $s .= $block;
            if ($i%2) $s .= $pc;
            $i++;
        }
        return $s;
    }

    //=========================================================
    function safe_stream($str) {
        if (preg_match("(<\?|\?>|<\%|\%>)", $str) or
            preg_match("/^[\r\n]/", $str) or
            preg_match("/[\r\n]\$/", $str)
            ) return false;
        return true;
    }

    //=========================================================
    function php_encode($tplname, &$php_array) {
        $enc = array();
        eval($this->tpl[$tplname]['code_enc']);
        return $enc;
    }

    //=========================================================
    function parse_encoding($tplname, $enc) {
        $s = $this->tpl[$tplname]['code_dec'];
        foreach ($enc as $var => $val) {
            $s = str_replace('{'.strtoupper($var).'}', $val, $s);
        }
        return $s;
    }

    //=========================================================
    function remove_tpl_vars(&$phpsource) {
        preg_match_all('/{[A-Z_]+}/', $phpsource, $out, PREG_OFFSET_CAPTURE + PREG_SET_ORDER);
        $rep = array();
        for ($i=0; $i<count($out); $i++) {
            if (!$this->morpher->in_php($out[$i][0][1], $phpsource)) continue;
            $rep[] = array('pos' => $out[$i][0][1], 'len' => strlen($out[$i][0][0]), 'new' => '');
        }
        $phpsource = $this->morpher->do_replacements($phpsource, $rep);
        return $phpsource;
    }

    //=========================================================
    function init_trace() {
        $mazelevel = $this->maze_level + 2;
        for ($i=1; $i<=$mazelevel; $i++) {
            $this->trace[$i] = array('eval' => rand(1, 3), 'func' => rand(1, 2));
        }
    }

    //=========================================================
    function get_trace_info($level = 0) {
        if ($level == 0) $level = $this->current_maze_level;
        return $this->trace[$level];
    }

    //=========================================================
    function get_trace($level) {
        $t = &$this->trace;
        $l_arr = array();
        for ($i=count($t); $i>=$level; $i--) {
            $l_arr[] = "eval()'d code({$t[$i]['eval']})";
            $l_arr[] = "runtime-created function({$t[$i]['func']})";
        }
        $l = implode(' : ', $l_arr);
        $l = substr($l, 0, strlen($l) - 3);
        return $l;
    }

    //=========================================================
    function run() {
        if ($this->file_src <> '')
            $this->content_src = $this->file_load($this->file_src);
        if (strlen($this->content_src) == 0) {
            $this->to_log('Encoding data is empty, nothing to do.');
            return false;
        }
        $content = $this->content_src;
        srand(time());
        $mazelevel = $this->maze_level + 2;
        if (!$this->morph_level) $this->morph_level = 2;
        $valid_names = array();
        foreach ($this->tpl_names as $name) {
            if (version_compare($this->tpl[$name]['php_version'], $this->options['phpversion'], '<=') == 1)
                $valid_names[] = $name;
        }
        if (!count($valid_names)) {
            $this->to_log('No valid encoding libs');
            return false;
        }
        
        $this->init_trace();

        for ($i=1; $i<=$mazelevel; $i++) {
            $this->current_maze_level = $i;
            if ($i == 1) {
                if ($this->options['turck']) $tplname = '_bottom_turck';
                    else $tplname = '_bottom';
                $showlevel = 'bottom wrapper';
            } else
            if ($i == $mazelevel) {
                if ($this->options['turck']) $tplname = '_top_turck'; else
                if ($this->options['compress']['enable']) $tplname = '_top_compress';
                    else $tplname = '_top';
                $showlevel = 'top wrapper';
            } else {
                $tplname = $valid_names[rand(1, count($valid_names))-1];
                $showlevel = $i-1;
            }
            $a = $this->php_explode($content);
            $this->to_log("Mazing ".basename($this->file_src)." level '$showlevel' using template '$tplname'");
            $enc = $this->php_encode($tplname, $a);
            $content = $this->parse_encoding($tplname, $enc);
            if ($i == $mazelevel)
                $content = str_replace('{PHPVERSION}', $this->options['phpversion'], $content);
            if ($this->morph_level) {
                $this->morpher->trace_info = $this->trace[$i];
                $content = $this->morpher->process($content, $this->morph_level);
            }
            $content = $this->remove_tpl_vars($content);
            if ($i == $mazelevel) {
                if ($this->options['turck']) $src = $this->turck_encoded_src; else
                    $src = $this->php_implode($this->php_explode($this->content_src));
                $content = substr($content, 0, strlen($content)-2)."\r\n".$this->copyright."\r\n".'?'.'>';
                $content2 = substr($content, 50);
                $key = md5(crc32($content2) + crc32($src));
                $content = preg_replace("/_V000=_{34}/", "\$V000='$key'", $content);
            }
        }
        if (!$this->file_save($this->file_dst, $content)) {
            $this->to_log('Can not create output file '.$this->file_dst);
            return true;
        } else
            return true;
    }
    

}


?>
