<?
/**
* This is a file class used within the Base class to handle file content presentation.
*/
class _File extends Base{
	/**
	* Return filestream of desired file.
	*
	* Read file from web safe location.
	* This is ideal for non public files - but not web images !
	*
	* This function will handle all needed headers inorder to start stream.
	*/
	function getContent() {
		$fp = fopen($this->filename, 'rb');

		// decrease cpu usage extreme - http://no2.php.net/header
		@ob_end_clean();

		// Send the right headers.
		header("Content-Type: ".$this->type);
		header("Content-Length: ".$this->size);
		header('Content-Description: File Transfer');
	        //header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Cache-Control: public");
		header("Content-Disposition: attachment; filename=".rawurldecode($this->name));
		//header("Content-Disposition: inline; filename=".rawurldecode($this->name));
		header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		header('Accept-Ranges: bytes');
		header("Cache-control: private");
		header('Pragma: private');

		// Dump the file and stop the script.
		fpassthru($fp);
		fclose($fp);

		return true;
	}
}
?>