﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (IsJavascriptActive)
        {
            Response.Write("Javascript active");
        }
        else
        {
            Response.Write("Javascript inactive");
        }
    }
    /// <summary>
    /// boolean indicating if javascript is active on the client browser
    /// </summary>
    public static bool IsJavascriptActive
    {
        get
        {
            bool active = false;
            HttpContext context = HttpContext.Current;
            if (!context.Request.Browser.Crawler)
            {
                if (context.Session["jsActive"] == null)
                {
                    context.Response.Redirect("JSDetect.aspx?url=" + context.Request.Url.AbsoluteUri.ToString() + " ", true);
                }
                else
                {
                    if (context.Session["jsActive"].ToString().Equals("0"))
                    {
                        active = false;
                    }
                    else if (context.Session["jsActive"].ToString().Equals("1"))
                    {
                        active = true;
                    }
                }
            }
            return active;
        }
    }
    /// <summary>
    /// Domain name and port
    /// </summary>
    public static string ClientDomainName
    {
        get
        {
            return HttpContext.Current.Request.Url.AbsoluteUri.Substring(0, HttpContext.Current.Request.Url.AbsoluteUri.Length - HttpContext.Current.Request.Url.PathAndQuery.Length);
        }

    }
}
