﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI.WebControls;
using System.Drawing;
using System.Data;

namespace TimeSheetDemo
{
    public partial class Default : System.Web.UI.Page
    {
        private string _seperator = "|";

        protected void timeSheetGrid_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            //number of cells in the row
            int cellCount = e.Row.Cells.Count;

            //iterating through every cells and check for the status for each employees
            for (int item = 3; item < cellCount; item = item + 3)
            {
                if (e.Row.Cells != null)
                {
                    var cellText = e.Row.Cells[item].Text;
                    switch (cellText)
                    {
                        case "WDAY"://Working Day
                            e.Row.Cells[item].VerticalAlign = VerticalAlign.Middle;
                            break;
                        case "LEAVE"://Leave
                            e.Row.Cells[item].VerticalAlign = VerticalAlign.Middle;
                            e.Row.Cells[item].BackColor = Color.FromArgb(255, 255, 000);
                            e.Row.Cells[item - 1].BackColor = Color.FromArgb(255, 255, 000);
                            e.Row.Cells[item - 2].BackColor = Color.FromArgb(255, 255, 000);
                            break;

                        case "HDAY"://Holiday
                            e.Row.Cells[item].VerticalAlign = VerticalAlign.Middle;
                            e.Row.Cells[item].BackColor = Color.FromArgb(255, 0, 0);
                            e.Row.Cells[item - 1].BackColor = Color.FromArgb(255, 0, 0);
                            e.Row.Cells[item - 2].BackColor = Color.FromArgb(255, 0, 0);
                            break;
                    }
                }
            }
        }

        protected void timeSheetGrid_RowCreated(object sender, GridViewRowEventArgs e)
        {
            //If row type= header customize header cells
            if (e.Row.RowType == DataControlRowType.Header)
                CustomizeGridHeader((GridView)sender, e.Row, 2);
        }


        /// <summary>
        /// Customizing grid header
        /// </summary>
        /// <param name="timeSheetGrid">Time Sheet Gridview Control</param>
        /// <param name="gridRow">Row created</param>
        /// <param name="headerLevels">levels of header to be customized</param>
        private void CustomizeGridHeader(GridView timeSheetGrid, GridViewRow gridRow, int headerLevels)
        {
            for (int item = 1; item <= headerLevels; item++)
            {
                //creating new header row
                GridViewRow gridviewRow = new GridViewRow(0, 0, DataControlRowType.Header, DataControlRowState.Insert);
                IEnumerable<IGrouping<string, string>> gridHeaders = null;

                //reading existing header 
                gridHeaders = gridRow.Cells.Cast<TableCell>()
                            .Select(cell => GetHeaderText(cell.Text, item))
                            .GroupBy(headerText => headerText);

                foreach (var header in gridHeaders)
                {
                    TableHeaderCell cell = new TableHeaderCell();
                    
                    if (item == 2)
                    {
                        cell.Text = header.Key.Substring(header.Key.LastIndexOf(_seperator) + 1);
                    }
                    else
                    {
                        cell.Text = header.Key.ToString();
                        if (!cell.Text.Contains("DENTRY"))
                        {
                            cell.ColumnSpan = 3;
                        }
                    }
                    gridviewRow.Cells.Add(cell);
                }
                // Adding new header to the grid
                timeSheetGrid.Controls[0].Controls.AddAt(gridRow.RowIndex, gridviewRow);
            }
            //hiding existing header
            gridRow.Visible = false;
        }

        /// <summary>
        /// Reading header text for each levels
        /// </summary>
        /// <param name="headerText">Current header text</param>
        /// <param name="headerLevel">Header level to be customized</param>
        /// <returns>Modified header text</returns>
        private string GetHeaderText(string headerText, int headerLevel)
        {
            if (headerLevel == 2)
            {
                return headerText;
            }
            return headerText.Substring(0, headerText.LastIndexOf(_seperator));
        }

        protected void btnShow_Click(object sender, EventArgs e)
        {
            // Reading employee data
            DataTable employeeData = DataManager.GetEmployeeData();
            // Reading time sheet data for the employee for a data range
            DataTable timeSheetData = DataManager.GetTimeSheetData();

            // Creating a customized time sheet table for binding with data grid view
            var timeSheet = new DataTable("TimeSheet");

            timeSheet.Columns.Add("DENTRY" + _seperator + "");

            // creating colum header for each employee data
            foreach (DataRow item in employeeData.Rows)
            {
                string columnName = item["EMPLOYEENAME"].ToString().Trim();
                timeSheet.Columns.Add(columnName + _seperator + "InTime");
                timeSheet.Columns.Add(columnName + _seperator + "OutTime");
                timeSheet.Columns.Add(columnName + _seperator + "Status");
            }

            // setting start date
            DateTime currentDate = Convert.ToDateTime("05/21/2012");

            //creating 10 days time sheet data for each employee
            for (int i = 0; i < 9; i++)
            {
                var dataRow = timeSheet.NewRow();
                FillTimeSheetRow(timeSheetData, employeeData, currentDate, dataRow);
                timeSheet.Rows.Add(dataRow);
                currentDate = currentDate.AddDays(1);
            }

            //Binding time sheet table with data grid view
            timeSheetGrid.DataSource = timeSheet;
            timeSheetGrid.DataBind();
        }

        /// <summary>
        /// Filling time sheet grid for every employee
        /// </summary>
        /// <param name="timeSheetData">Time sheet data table</param>
        /// <param name="employees">Employee data</param>
        /// <param name="currentDate">Current data of time entry</param>
        /// <param name="dataRow">Row in the grid view</param>
        private void FillTimeSheetRow(DataTable timeSheetData, DataTable employees, DateTime currentDate, DataRow dataRow)
        {
            dataRow["DENTRY" + _seperator + ""] = currentDate.ToString("dd-MMM-yyyy");

            foreach (DataRow row in employees.Rows)
            {
                string columnName = row["EMPLOYEENAME"].ToString().Trim();
                string employeeId = (row["EMPLOYEEID"]).ToString().Trim();


                var dayStatus = "";
                // updating status as holiday for week ends
                if (currentDate.DayOfWeek.ToString() == "Saturday" || currentDate.DayOfWeek.ToString() == "Sunday")
                {
                    dayStatus = "HDAY";
                }

                // Fetching time sheet entry for the current data from time sheet data
                DataRow[] result = timeSheetData.Select("EMPLOYEEID='" + employeeId + "' AND DENTRY='" + currentDate.ToShortDateString() + "'");

                if (result.Length != 0)
                {
                    string status = result[0]["STATUS"].ToString();
                    dataRow[columnName + "|InTime"] = result[0]["INTIME"].ToString();
                    dataRow[columnName + "|OutTime"] = result[0]["OUTTIME"].ToString();
                    dayStatus = status;

                }
                dataRow[columnName + "|Status"] = dayStatus;
            }
        }
    }
}