﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace ManyToMany
{

    public partial class _Default : System.Web.UI.Page
    {
        ManyToManyEntities manyToMany = new ManyToManyEntities();

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                //Bind Dropdown details.
                this.BindDropdownDetails();
                this.BindGridDetails();
            }
        }
        protected void btnCust_Click(object sender, EventArgs e)
        {
            //set Default value as empty for error message.
            lblMessage.Text = string.Empty;

            try
            {
                //Get ProductId from Dropdown selection.
                int ProdId = Convert.ToInt32(drpProd.SelectedValue);               
                Customer c = new Customer();
                //Set Customer Name property
                c.CustName = txtCus.Text.Trim();
                //Get Prodct 
                Product p = manyToMany.Products.SingleOrDefault(x => x.ProductId == ProdId);
                //Add Product details to customer
                c.Products.Add(p);
                //Add customer details to EDMX class object
                manyToMany.Customers.AddObject(c);
                //Call SaveChanges method. Saving the records in DB will occur only when you call the SaveChanges Method.
                manyToMany.SaveChanges();
                this.BindDropdownDetails();
                lblMessage.Text = "Customer Added successfully";
                lblMessage.ForeColor = System.Drawing.Color.Green;
                lblMessage.Font.Bold = true;
                this.BindGridDetails();
                txtCus.Text = string.Empty;
            }
            catch (Exception ex)
            {
                lblMessage.Text = ex.Message;
            }
        }
        protected void btnProd_Click(object sender, EventArgs e)
        {
            //set Default value as empty for error message.
            lblMessage.Text = string.Empty;
            try
            {
                Product p = new Product();
                //Set the ProductName property from textbox.
                p.ProductName = txtProd.Text.Trim();
                manyToMany.Products.AddObject(p);
                manyToMany.SaveChanges();
                this.BindDropdownDetails();
                lblMessage.Text = "Product Added successfully";
                lblMessage.ForeColor = System.Drawing.Color.Green;
                lblMessage.Font.Bold = true;
                txtProd.Text = string.Empty;
            }
            catch (Exception ex)
            {
                lblMessage.Text = ex.Message;
            }
        }
        protected void grdDetails_RowEditing(object sender, GridViewEditEventArgs e)
        {
            grdDetails.EditIndex = e.NewEditIndex;
            this.BindGridDetails();
        }
        protected void grdDetails_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            int CustId = Convert.ToInt32(((Label)grdDetails.Rows[e.RowIndex].FindControl("lblCusId")).Text);
            int ProdId = Convert.ToInt32(((Label)grdDetails.Rows[e.RowIndex].FindControl("lblPId")).Text);
            
            Customer cus = (from c in manyToMany.Customers where c.CustomerId == CustId select c).FirstOrDefault();
            cus.CustName = e.NewValues["CustName"].ToString();
            Product prod = (from p in manyToMany.Products where p.ProductId == ProdId select p).FirstOrDefault();
            prod.ProductName = ((DropDownList)grdDetails.Rows[e.RowIndex].FindControl("drpProd1")).SelectedItem.Text;
            prod.ProductId = Convert.ToInt32( ((DropDownList)grdDetails.Rows[e.RowIndex].FindControl("drpProd1")).SelectedItem.Value);
            manyToMany.Customers.ApplyCurrentValues(cus);            
            manyToMany.Products.ApplyCurrentValues(prod);
            manyToMany.SaveChanges();

            grdDetails.EditIndex = -1;
            this.BindDropdownDetails();
            this.BindGridDetails();
        }
        protected void grdDetails_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            int CustId = Convert.ToInt32(((Label)grdDetails.Rows[e.RowIndex].FindControl("lblCusId")).Text);
            int ProdId = Convert.ToInt32(((Label)grdDetails.Rows[e.RowIndex].FindControl("lblPId")).Text);

            Customer cus = (from c in manyToMany.Customers where c.CustomerId == CustId select c).First();
            Product prod = (from p in manyToMany.Products where p.ProductId == ProdId select p).First();
            cus.Products.Attach(prod);
            manyToMany.Customers.DeleteObject(cus);
            manyToMany.SaveChanges();
            this.BindGridDetails();
        }
        protected void grdDetails_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            grdDetails.EditIndex = -1;
            this.BindGridDetails();
        }

        #region Binding Dropdowns & GridView

        private void BindGridDetails()
        {
            var _custProList = (from c in manyToMany.Customers.Where(f => f.Products.Any())
                                from p in manyToMany.Products.Where(g => g.Customers.Contains(c))
                                select new { c.CustomerId, c.CustName, p.ProductId, p.ProductName });

            grdDetails.DataSource = _custProList;
            grdDetails.DataBind();
        }
        private void BindDropdownDetails()
        {
            //set Default value as empty for error message.
            lblMessage.Text = string.Empty;

            try
            {
                drpProd.Items.Clear();
                drpProd.Items.Add(new ListItem("--Select--", ""));
                drpProd.DataTextField = "ProductName";
                drpProd.DataValueField = "ProductId";
                drpProd.DataSource = manyToMany.Products;
                drpProd.DataBind();
            }
            catch (Exception ex)
            {
                lblMessage.Text = ex.Message;
            }
        }

        #endregion

        protected void grdDetails_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {

                LinkButton lnk1 = (LinkButton)e.Row.Cells[e.Row.Cells.Count - 1].Controls[2];
                if(lnk1.Text=="Delete")
                lnk1.Attributes.Add("onclick", "if(window.confirm('Are you sure,You want to delete?'))return true;else return false;");   

                DropDownList drpProd = (DropDownList)e.Row.FindControl("drpProd1");
                Label lblPId = (Label)e.Row.FindControl("lblPId");
                int Pid = Convert.ToInt32(lblPId.Text);

                drpProd.Items.Clear();
                drpProd.Items.Add(new ListItem("--Select--", ""));
                drpProd.DataTextField = "ProductName";
                drpProd.DataValueField = "ProductId";
                drpProd.DataSource = manyToMany.Products;
                drpProd.DataBind();
                drpProd.SelectedValue = Pid.ToString();


            }
        }
    }
}
