<?php

  $valid = array(

    1  => 'test@example.com',
    2  => 'test@example.co.uk',
    3  => 'test@example.museum',
    4  => 'test@example',
    5  => 'test@xn--example.com',
    6  => 'test@example.xn--com',
    7  => 'test.test@example.com',
    8  => "!#$%&'*+-/=?^_`{|}~@example.com",
    9  => 'test@123.com',
    10 => 'test@example.123',
    10 => 'abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijkl@example.com',
    11 => 'test@abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijk.com',
    11 => 'test@example.abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijk',
    12 => 'a@a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v',
    13 => '"test"@example.com',
    14 => '"test@test"@example.com',
    15 => '"test".test@example.com',
    16 => 'test@[255.255.255.255]',
    17 => 'test@[IPv6:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF]',
    18 => 'test@[IPv6:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF::FFFF]',
    19 => 'test@[IPv6:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:255.255.255.255]',
    20 => 'test@[IPv6:FFFF:FFFF:FFFF:FFFF:FFFF::255.255.255.255]',
    21 => ' test @ example . com ',
    22 => '(comment)test@example.com',
    23 => '((nested)comment)test@example.com',
    24 => 'test@(comment)[255.255.255.255]',
    25 => '"My name".is."Michael" (and I am (really) awesome) @ ("That\'s what she said") example . com',

  );

  $invalid = array(

    1  => 'test',
    2  => 'test@',
    3  => '@example.com',
    4  => 'test.@example.com',
    5  => '.test@example.com',
    6  => 'test..test@example.com',
    7  => 'test@example..com',
    8  => "tst@example.com",
    9  => '"test@example.com',
    10 => 'test"@example.com',
    10 => '"\"@example.com',
    11 => '"test"account"@example.com',
    12 => 'a@a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x.y.z.a.b.c.d.e.f.g.h.i.j.k.l.m.n.o.p.q.r.s.t.u.v.w.x',
    13 => '"test"test@example.com',
    14 => 'test\@test@example.com',
    15 => 'test@exam!ple.com',
    16 => 'test@[255.255.255.256]',
    17 => 'test@[IPv6:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF]',
    18 => 'test@[IPv6:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF::FFFF:FFFF]',
    19 => 'test@[IPv6:FFFF:FFFF:FFFF:FFFF:FFFF:255.255.255.255]',
    20 => 'test@[IPv6:FFFF:FFFF:FFFF:FFFF:FFFF::FFFF:255.255.255.255]',
    21 => 'test test@example.com',
    22 => '(commenttest@example.com',
    23 => '((nestedcomment)test@example.com',
    24 => 'test@[255(comment).255.255.255]',
    25 => ' @ ',

  );

  include 'EmailAddressValidator.php';

  foreach ($valid as $address)
  {

    if (!EmailAddressValidator::setEmailAddress($address, 5322)->isValid())
    {
      echo 'Incorrect result: ' . $address . ' is a <strong>valid</strong> address.<br />';
    }

  }

  foreach ($invalid as $address)
  {

    if (EmailAddressValidator::setEmailAddress($address, 5322)->isValid())
    {
      echo 'Incorrect result: ' . $address . ' is an <strong>invalid</strong> address.<br />';
    }

  }