<?php
//ini_set("display_errors", "1");
//ini_set("error_reporting", "E_ALL");

/*
	I'm going to call this version AdvATE, for Advanced Ajax Table Edit.
	Many things are the same, however some are different.  In your php file
	that hanldes the showing of the data, you only need the bottom part of this
	example.  The major difference here is that the data is not merely a 
	value in the array, but	is part of another sub array...so your data 
	should look like this:
		$data = array(
					[rowid] => array(
									[firstcol] = array(
													[data] => "the data to be displayed"
													[input] => the name of the input to return from ajax
												)
									[secondcol] = array(
													[data] => "the data to be displayed"
													[input] => the name of the input to return from ajax
												)
									etc...
	
	I highly recommend inspecting the example data array to see how it works.
	
	The second part of the script, which can be either the same script as in the example,
	or a seperate page, is the Form Input Requests and the code to update the data
	when it is sent from the page.
	
	If you notice in the example, there is an if statement that controls everything.
	When the user clicks on a cell to update it, a request is sent to the server, that 
	request contains two things: the name of the input to retrieve, and the value 
	"FormRequest" set to true.  When the "Save" button is pressed, it sends four 
	things: the new value, the colid, the rowid, and the var "FormSave" with a value of 
	true.  Those variables, FormRequest	and FormSave, are used to determine what to 
	do by your php script.  I extract the $_POST because I think it's easier, but 
	you don't have to.
	
	The next step is to configure the inputs to be returned for your cells.  These
	are created by you, so you can name them what ever you want.  I named them by 
	column.  The function SetForm takes three inputs:

		SetForm('str name of the input to reference it by', 'str type', 'arr values');
	
	The name and type are required, the values is not unless it is a radio, select, or check.
	Valid types are: 
		radio	presents the user with a set of radio buttons 
		text	gives a text box
		area	gives a text area
		check	gives a set of checkboxs
		select	gives a select box
		bypass	if a cell is set to bypass, then it is not editable
		
	The values array contains the values for radio, check, and select types.  It is in
	key => value form...so if you pass 'key' => 'value' to a radio button input type
	the html will be: <input type="radio" name="new" value="key"> value
	
	The last part of the script that you must write is how to handle the data.
	When save is pressed, it will always send four variables in the post:
		rowid
		colid
		new
		FormSave
	rowid and colid are the identifiers for which cell was selected.  new is the value
	that the user selected/entered.  This is slightly different from before...with all of
	the input types but check, it will be the value of what the user input/selected.  If it
	is a check input, $_POST['new'] will be an array consisting of the values of the 
	inputs that were checked...I recommend doing a print_r on post if this is confusing.
	
	Another big difference is that you must return some sort of value to the ajax script
	after processing the user submitted data.  The value that you return will be displayed
	in the cell of the table that was selected.  Even if you just do "echo $_POST['new']"
	after the data processing, then it will display that value in the cell.  This allows
	you greater flexibilty over showing the updated cells.

	
*/

include("./AdvATE.class.php");
$at = new TableEditor;

extract($_POST);

	/* 
		This section can be it's own seperate page, just change the SetSubmit value
		to the proper page.  Your visitors do not have to visit this page, only
		the ajax needs to know it's name.
	*/
if ($FormRequest) {
	/*
		If it is a form request being sent, there are three things that are posted:
			type:			the name of the form input...the first input in SetForm
							if you have not set that input type with SetForm, it will return nothing
							presenting the user with only a "Save" and "Cancel" button.
					
			FormRequest:	This will always be set to "true" if it is a form request
			
	*/
	

	$at->SetForm('col0input','radio',array('four' => '4', 'five' => '5', 'six' => '6'));
	$at->SetForm('col1input','text');
	$at->SetForm('col2input','area');
	$at->SetForm('col3input','check',array('one' => '1', 'two' => '2', 'three' => '3'));

	echo $at->HandleFormRequest($_POST['type']);
	
} else if ($FormSave) {
	/*
		If it is a save request being sent, there are four things that are posted:
			rowid:			the row id for the edited cell
			
			colid:			the column name for the edited cell
					
			new:			the new value for the cell.  Remember, if the input type
							was checkbox this will be an array of the checked values.
			
			SaveForm:		This will always be set to "true" if it is a save request
			
	*/
	
	//print_r($_POST);
	
	extract($_POST);

	$data = file_get_contents("./Atest.txt");
	$data = unserialize($data);
	
	if ($colid == "col3") {
		$update = "You checked ";
		foreach ($new as $value) {
			$update .= "$value ";
		}
	} else {
		$update = $new;
	}

	$data[$rowid][$colid]['data'] = $update;

	//if this were a database, you could use the following SQL statement:
	//UPDATE $tablename SET `$colid` = '$new' WHERE id = '$rowid'
	//you should do some verification on the data input by the user.
	
	$open = fopen("./Atest.txt", 'w');
	fwrite($open, serialize($data));
	fclose($open);
	
	echo $update;
	
} else {
	/*
		This is the part of the script that displays your data.  The name
		of this page is the name of the page your visitors will see.

		The data should be a multidimensional array that consists of the data for the table.
		It should be in the following format:
			In the primary array, each element should have a key eqaul to the row id and the value is
			a sub array that contains column data.
			
			The column data subarray should have key values that are the column values from the db 
			and the values are subarrays that consist of two values:
				data:	the data to be displayed
				input:	the name of the input to be presented to the user
				
		See above for more information.
			
		An example would be:
			[1] => array(
					[Name] => array(
							[data] => 'Some Guy'
							[input] => 'col1input'
						)
					[Address] => array(
							[data] => '123 Some Street'
							[input] => 'col2input'
						)
					[Phone] => array(
							[data] => '123-123-1234'
							[input] => 'col3input'
						)
				)
			etc.
			
	*/
	
	//the display properties for the odd and even rows
	$odd = array('style' => 'background-color: #CCCCCC;');
	$even = array('style' => 'background-color: #EEEEEE;');

	//the display properties for the overall table
	$table = array('align' => 'center', 'cellpadding' => '3', 'cellspacing' => '0', 'width' => '50%');

	//table column header information
	$headers = array("Col 0", "Col 1", "Col 2", "Col 3");
	$headerattrib = array('style' => 'background-color: skyblue');
	
	$at->SetEvenRowAttribs($even);
	$at->SetOddRowAttribs($odd);
	
	$at->SetTableAttribs($table);
	
	$at->SetHeaderAttribs($headerattrib);
	$at->SetHeaders($headers);
	
	$at->SetSubmit("AdvATEexample.php");
	
	//checks for the example data, or creates it if not found
	if (file_exists("./Atest.txt")) {
		$data = file_get_contents("./Atest.txt");
		$data = unserialize($data);
	} else {
		for ($a = 0; $a < 5; $a++) {
			for ($b = 0; $b < 4; $b++) {
				if ($b == 0) {
					$input = 'col0input';
				} else if ($b == 1) {
					$input = 'col1input';
				} else if ($b == 2) {
					$input = 'bypass';
				} else if ($b == 3) {
					$input = 'col3input';
				}
					
				$data[$a]["col" . $b] = array('data' => "Row $a column $b", 'input' => $input);
			}
		}
		
		$open = fopen("Atest.txt", 'w');
		fwrite($open, serialize($data));
		fclose($open);
	}
	
	$at->SetData($data);
	
	echo $at->GenerateTable();
	
	//echo "<pre>";
	//print_r($data);

}

?>
