<?php

//xzypdf - version 0.2.1 // 201209101813
//extends fpdf with some tricks
// *http://www.fpdf.org/en/script/script36.php
// * methods provided by Johannes Güntert classes
// * @author Luis Martínez Ulloa
// without dynamic row heights support, yet (todo) 

require_once 'fpdf.php';
    
class xzypdf extends FPDF {
    var $vars = array(
        'align' => 'L', //LCRJ
        'border' => 0,
        'fill' => false,
        'attr' => '',
        'height' => 6,
        'row' => 0,
        'col' => 0,
        'ln' => 0,
        'family' => 'Arial',
        'style' => '',
        'size' => 9,
        'top' => 0,
        'left' => 0,
        'rows' => 1,
        'cols' => 1,
        'multicell' => false,
        'clip' => false,
        'color'=>0,
        'background'=>255,
        'draw'=>0
    );
    
    var $javascript;
    var $n_js;
//------------------------------------------------------------------------------
    function __construct($a = null, $b = null, $c = null){
        parent::__construct($a,$b,$c);
        //$this->vars['widths'] = $widths;
    }
//------------------------------------------------------------------------------
    
    function _cell($text,$attrs = null){
        if ($attrs != null) {
            $this->setvars($attrs);
        }
        $this->rendercell($text);
    }
//------------------------------------------------------------------------------
    
    function setvars($attrs) {
        foreach($attrs as $key => $value) {
            $this->vars[$key] = $value;
        }
    }
//------------------------------------------------------------------------------
    
    function startx($col){
        $start = 0;
        for ($cont = 0; $cont < $col; $cont++) {
            $start += $this->vars['widths'][$cont];
        }
        return $start;
    }
//------------------------------------------------------------------------------

    function fromto($from,$to){
        $width = 0;
        for ($cont = $from; $cont < $to; $cont++) {
            $width += $this->vars['widths'][$cont];
        }
        return $width;
    }
//------------------------------------------------------------------------------
    
    function box() {
        extract($this->vars);
        $x = $this->startx($col);
        $y = $row * $height;
        $w = $this->fromto($col,$col + $cols);
        $h = $rows * $height;
        return array($x,$y,$w,$h);
    }
//------------------------------------------------------------------------------
    
    function splitstr($txt,$width) {
	//devuelve una lista de cadenas partidas por espacio con ancho menor a width
	$tmp1 = $txt;
	$pos = 0;
	do {
	    do {
		$lastsp = $pos;
		if(($pos = strpos($tmp1, ' ', $lastsp)) === false) {
		    $lastsp = strlen($tmp1) - 1;
		    break;
		}
		$newwidth = $this->GetStringWidth(substr($tmp1,0,$pos));
	    } while($width > $newwidth);
	    $parts[] = substr($tmp1, 0, $lastsp);
	    $tmp1 = substr($tmp1, $lastsp +1);
	} while ($tmp1 != '');
	return $parts;
    }
//------------------------------------------------------------------------------
    function clip($texto, $ancho) {
        $palabras = explode(' ', $texto);
        for($cont = count($palabras); $cont>0; $cont--){
            $parrafo = $this->words($palabras, $cont);
            if ($ancho >= $this->GetStringWidth($parrafo)){
                break;
            }
        }
        return (count($palabras) > $cont)? "$parrafo...": $parrafo;
    }

    function words($palabras, $num){
        $parrafo = array_slice($palabras, 0, $num);
        return (implode(' ', $parrafo));
    }
    
    function setcolors(){
        extract($this->vars);
        if (is_array($draw)) {
            $this->SetDrawColor($color(0), $color(1), $color(2));
        } else {
            $this->SetDrawColor($color);
        }
        if (is_array($color)) {
            $this->SetTextColor($color(0), $color(1), $color(2));
        } else {
            $this->SetTextColor($color);
        }
        if (is_array($background)) {
            $this->SetFillColor($background(0), $background(1), $background(2));
        } else {
            $this->SetFillColor($background);
        }
    }
    
    function rendercell($txt) {
        extract($this->vars);
        list($x,$y,$w,$h) = $this->box();
        $this->SetXY($x + $left,$y + $top);
        $this->SetFont($family, $style, $size);
        $text = utf8_decode($txt);
        $this->setcolors();
        if ($clip === true) {
            $txt2 = $this->clip($text, $w);
            $this->Cell($w, $h, $txt2, $border, $ln, $align, $fill);
        } else 
            if ($multicell === true) {
            $this->Cell($w, $h, ' ', $border, $ln, $align, $fill);
            $this->SetXY($x + $left,$y + $top);
	    if ($align == 'C'){
		$ht = $height * $vshift;
		$yi = $y + ($h - $ht) / 2; //parche trucho, arreglar la funcion de arriba
		$this->SetXY($x + $left,$yi + $top);
	    } 
            $this->MultiCell($w, $height, $text,0,$align); //el alto de la celda es el espaciado entre lineas
        } else {
            $this->Cell($w, $h, $text, $border, $ln, $align, $fill);
        }
    }
//------------------------------------------------------------------------------

    function IncludeJS($script) {
        $this->javascript=$script;
    }
//------------------------------------------------------------------------------

    function _putjavascript() {
        $this->_newobj();
        $this->n_js=$this->n;
        $this->_out('<<');
        $this->_out('/Names [(EmbeddedJS) '.($this->n+1).' 0 R]');
        $this->_out('>>');
        $this->_out('endobj');
        $this->_newobj();
        $this->_out('<<');
        $this->_out('/S /JavaScript');
        $this->_out('/JS '.$this->_textstring($this->javascript));
        $this->_out('>>');
        $this->_out('endobj');
    }
//------------------------------------------------------------------------------

    function _putresources() {
        parent::_putresources();
        if (!empty($this->javascript)) {
            $this->_putjavascript();
        }
    }
//------------------------------------------------------------------------------

    function _putcatalog() {
        parent::_putcatalog();
        if (!empty($this->javascript)) {
            $this->_out('/Names <</JavaScript '.($this->n_js).' 0 R>>');
        }
    }
//------------------------------------------------------------------------------
    
    function AutoPrint($dialog=false)
    {
	//Open the print dialog or start printing immediately on the standard printer
	$param=($dialog ? 'true' : 'false');
	$script="print($param);";
	$this->IncludeJS($script);
    }
//------------------------------------------------------------------------------

    function AutoPrintToPrinter($server, $printer, $dialog=false)
    {
	//Print on a shared printer (requires at least Acrobat 6)
	$script = "var pp = getPrintParams();";
	if($dialog)
	    $script .= "pp.interactive = pp.constants.interactionLevel.full;";
	else
	    $script .= "pp.interactive = pp.constants.interactionLevel.automatic;";
	$script .= "pp.printerName = '\\\\\\\\".$server."\\\\".$printer."';";
	$script .= "print(pp);";
	$this->IncludeJS($script);
    }
//------------------------------------------------------------------------------

}

?>