<?php

/**
 *
 * @package Common_functions_collection
 * @author anoop
 * @copyright Copyright (c) 2008
 * @version 0.0
 * @access protected
 */

	/**
	* Loads the main config.php file
	* Function::&get_config()
	* @access	private
	* @return	array
	*/
	function &get_config()
	{
		static $main_conf;
		global $config,$wgConfig;
		if ( ! isset($main_conf))
		{
			if ( ! file_exists(dirname(__FILE__).'/config'.EXT))
			{
				exit('The configuration file config'.EXT.' does not exist.');
			}
			if(!is_object($wgConfig))
			{
			    $wgConfig=loadObject('config');
			}
			if ( ! isset($config) OR ! is_array($config))
			{
				exit('Your config file does not appear to be formatted correctly.');
			}

			$main_conf[0] =& $config;
		}
		return $main_conf[0];
	}
	/**
	 * Function::loadObject()
	 *
	 * @param mixed $extension
	 * @param mixed $wgName
	 * @return
	 */
	function &loadObject($extension)
	{
	      $wgName='';
	      include_once(dirname(__FILE__)."/core_i8e_engine.php");
	      $wgName= new $extension();
	      return $wgName;
	}

	/**
	 * data_prepare()
	 * Function::log_message()
	 * @param mixed $data
	 * @return
	 */
	function  data_prepare($data)
	{
		if (!get_magic_quotes_gpc())
		{
			$result = addslashes(trim($data));
		}
		else
		{
			$result = trim($data);
		}
		return $result;
	}
	/**
	* Error Logging Interface
	* Function::log_message()
	* We use this as a simple mechanism to access the logging
	* class and send messages to be logged.
	*
	* @access	public
	* @return	void
	*/
	function log_message($level = 'error', $message, $php_error = FALSE)
	{
		global $wgLog;
		if(is_object($wgLog))
		{
			$wgLog->write_log($level, $message, $php_error);
		}
		else
		{
			$wgLog=loadObject('log');
			$wgLog->write_log($level, $message, $php_error);
		}
	}

	function getMetaDescription()
	{
		global $config;
		if(is_array($config) && !empty($config["description"]))
		{
			/** Log Messages **/
	  	log_message("debug","Common Function::getMetaDescription() --> ".$config["description"]);

			return $config["description"];
		}
		else
		{
			/** Log Messages **/
	  	log_message("debug","Common Function::getMetaDescription() --> CMS Pages Description");

			return "CMS Pages";
		}
 }
 function getMetaKeywords()
 {
 		global $config;
	 	if(is_array($config) && !empty($config["keywords"]))
		{
				/** Log Messages **/
	  		log_message("debug","Common Function::getMetaKeywords() --> ".$config["keywords"]);

				return $config["keywords"];
		}
		else
		{
			/** Log Messages **/
	  	log_message("debug","Common Function::getMetaKeywords() --> CMS Pages Keywords");

			return "CMS Pages";
		}
 }
 function getMetaTitle()
 {
 		global $config;
 		if(is_array($config) && !empty($config["title"]))
		{
			/** Log Messages **/
	  	log_message("debug","Common Function::getMetaTitle() --> ".$config["title"]);

			return $config["title"];
		}
		else
		{
			/** Log Messages **/
	  	log_message("debug","Common Function::getMetaTitle() --> CMS Pages Title");

			return "CMS Pages Title";
		}
 }
 function getCss()
 {
 		global $config;
 		$link="";
 		$ThemeDir=THEME_DIR;
 		if(empty($ThemeDir))
 		{
 			$ThemeDir="theme/default/";
	 	}
		$files=getFiles($ThemeDir,"css");
 		foreach($files as $key => $value)
 		{
 			if($value!="" && strlen($value)>2)
 			{
 				$link.="<link href='".$config["SiteUrl"].$ThemeDir."css/".$value."'	rel='stylesheet' type='text/css' />";
 			}
 		}

		if(getLoginDetail()){
			$link.="<link href='".$config["SiteUrl"]."css/adminDefault.css'	rel='stylesheet' type='text/css' />";
		}
 		/** Log Messages **/
	  log_message("debug","Common Function::getCss() --> ".$link);

 		return $link;
 }
 function getJs()
 {
 		global $config;
 		$script="";
 		$ThemeDir=THEME_DIR;
 		if(empty($ThemeDir))
 		{
 			$ThemeDir="theme/default/";
	 	}
		$files=getFiles($ThemeDir,"js");
 		foreach($files as $key => $value)
 		{
 			if($value!="" && strlen($value)>2)
 			{
 				$script.="<script type='text/javascript' src='".$config["SiteUrl"].$ThemeDir."js/".$value."'></script>";
 			}
 		}
 		/** Log Messages **/
	  log_message("debug","Common Function::getJs() --> ".$script);

 		return $script;
 }

 function getHeaderImage()
 {
		global $config,$wgDb;
 		$script="";
 		$ThemeDir=THEME_DIR."images/";
 		if(empty($ThemeDir))
 		{
 			$ThemeDir="theme/default/images/";
	 	}
	 	/** Log Messages **/
	  log_message("debug","Common Function::getHeaderImage() --> ".$config["SiteUrl"].$ThemeDir.$config["HeaderImage"]);

		return $config["SiteUrl"].$ThemeDir.$config["HeaderImage"];
 }

 function getNewsImage()
 {
		global $config,$wgDb;
 		$script="";
 		$ThemeDir=THEME_DIR."images/";
 		if(empty($ThemeDir))
 		{
 			$ThemeDir="theme/default/images/";
	 	}
	 	/** Log Messages **/
	  log_message("debug","Common Function::getHeaderImage() --> ".$config["SiteUrl"].$ThemeDir.$config["NewsImage"]);

		return $config["SiteUrl"].$ThemeDir.$config["NewsImage"];
 }


 function editMetaTageHeaderImage()
 {
 		global $config;

 		if(isset($config["PageId"]) && !empty($config["PageId"]) && getLoginDetail())
 		{
 			$link="&nbsp;<a href='javascript:void(0);' onclick='editHeaderImage(\"".$config["PageId"]."\");'>edit header image</a>&nbsp;|&nbsp	&nbsp;<a href='javascript:void(0);' onclick='editMetaTag(\"".$config["PageId"]."\");'>edit Meta Info.</a>";

 			/** Log Messages **/
	  		log_message("debug","Common Function::editMetaTageHeaderImage() --> ".$link);

 			return $link;
 		}
 }
 function getLoginDetail()
 {
 		require_once("backend/inc/Users.php");
 		$userObj = new Users();
 		$userId = $userObj->getUserId();
 		/** Log Messages **/
	  	log_message("debug","Common Function::getLoginDetail() --> UserID==".$userId);
 		if(isset($userId) && !empty($userId) && $userId>0)
		{
			//check for admin login
			return true;
		}

 }
 function getEditLink($sectionAddOn)
 {
 		global $config;
		$selectContainer="";
		//$selectContainer.="<a href='javascript:void(0);' onclick='EditContent(\"$sectionAddOn\",\"".$config["PageId"]."\");'>edit</a>";
		$selectContainer.="<div class='editLinkAdmin'><a href='javascript:void(0);' onclick='EditContent(\"$sectionAddOn\",\"".$config["PageId"]."\");'>Edit Contents</a></div>";

		/** Log Messages **/
	  log_message("debug","Common Function::getEditLink(".$sectionAddOn.") --> ".$selectContainer);

		return $selectContainer;
 }

 function getMainMenuStatus()
 {
 	if(IS_MENU)
 	{
 		return true;
 	}
 	else
 	{
 		return false;
 	}
 }
 function getMainMenuJs(){
 	global $config;
 	$prepare="<script type='text/javascript' src='".$config["menuJsPath"]."'></script>";
 	return $prepare;
 }

 function getMainMenuCss(){
 	global $config;
 	$prepare="<link href='".$config["menuCssPath"]."' rel='stylesheet' type='text/css'>"; //To Do {define menuCssPath in config}
 	return $prepare;
 }

 function getMainMenu(){
 	global $wgTemplate;
 	if(IS_MENU){
 		return $wgTemplate->getMainMenu();
 	}
}

 function getSubMenu(){
 	global $wgTemplate;
 	if(IS_MENU){
 		return $wgTemplate->getSubMenu();
 	}
}

function getNews(){
 	global $wgTemplate;
 	if(IS_MENU){
 		return $wgTemplate->getNews();
 	}
}


function getFooterMenu(){
  global $wgTemplate;
  if(IS_FOOTER_LINK){
   return $wgTemplate->getFooterMenu();
  }
}

	/**
	|* Loads the main config.php file
	|* Function::&collectEnv()
	|* @access	public
	|* @return	array
	|*/
	function collectEnv()
	{
			global $config;
			$path=selfURL();					//GET: URL for page call
			$search_array=explode("index".EXT."/",$path);
			$config["SiteUrl"]=$search_array[0];
			if(strlen($search_array[1])>2 && $search_array[1]!="//")
			{
					$pageDetails=explode("/",$search_array[1]);

					if(strlen($pageDetails[0])>2 && $pageDetails[0]!="//")
					{
							$config["PageName"]=$pageDetails[0];
					}
					if($pageDetails[1]!="//")
					{
							$config["PageId"]=$pageDetails[1];
					}
			}
			else
			{
				$config["PageName"]="index";
				$config["PageId"]="1";
			}
		/** Log Messages **/
	    log_message("debug","Common Function::collectEnv() --> ".$config["PageName"]." --> ".$config["PageId"]);
	}

	function collectModuleEnv(){
		global $config;
		$path=selfURL();

		$config["PageName"]="index";
		$config["PageId"]="1";

		$search_array=explode("module".EXT."/",$path);
		$config["SiteUrl"]=$search_array[0];
		if(strlen($search_array[1])>2 && $search_array[1]!="//")
		{
				$pageDetails=explode("/",$search_array[1]);
				if(strlen($pageDetails[0])>2 && $pageDetails[0]!="//")
				{
						$config["ModuleName"]=$pageDetails[0];
				}
				if($pageDetails[1]!="//")
				{
						$config["ModuleId"]=$pageDetails[1];
				}
		}
		else
		{
				$config["ModuleName"]="ERROR";
				$config["ModuleId"]="0";
		}
		/** Log Messages **/
	    log_message("debug","Common Function::collectModuleEnv() --> ".$config["ModuleName"]." --> ".$config["ModuleId"]);

	}

	function redirect($location='')
	{
		if(!empty($location))
		{
			header("Location:".$config["SiteUrl"].$location);
		}
		else
		{
			header("Location:".$config["SiteUrl"]."index.php/index/1");
		}
	}
	function callback($buffer)
	{
  	// replace all the apples with oranges
  	return (str_replace("echo", " ", $buffer));
	}

	function selfURL() {
		 $s = empty($_SERVER["HTTPS"]) ? '' : ($_SERVER["HTTPS"] == "on") ? "s" : ""; $protocol = strleft(strtolower($_SERVER["SERVER_PROTOCOL"]), "/").$s; $port = ($_SERVER["SERVER_PORT"] == "80") ? "" : (":".$_SERVER["SERVER_PORT"]);
		return $protocol."://".$_SERVER['SERVER_NAME'].$port.$_SERVER['REQUEST_URI'];
	}
	function strleft($s1, $s2)
	{
		return substr($s1, 0, strpos($s1, $s2));
	}

	function getFiles($path,$folder="")
	{
		$dir=$path.$folder;
		$fileCollection=array();
		if (is_dir($dir))
		{
		    if ($dh = opendir($dir))
		    {
		        while (($file = readdir($dh)) !== false)
		        {
		            if(!empty($file))
		            {
			           	$fileCollection[]=$file;
			    			}
		        }
		    }
		 }
		 return $fileCollection;
	}

	/** FULL URL - END */
 /*function getEditLink()

 {
 		$selectContainer="";
		$selectContainer.="<script type='text/javascript' src='js/edit.js'></script>";
		return $selectContainer;
 }*/
?>