<?php //if((isset($_SERVER['PHP_AUTH_USER']) && isset($_SERVER['PHP_AUTH_PW']))&& ($_SERVER['PHP_AUTH_USER']!=="" && $_SERVER['PHP_AUTH_PW']!=="")){define(BASE,$_SERVER['PHP_AUTH_USER']);define(EXT,".php");}else{die("Illegal use of Script");}
/*
 * Created on Apr 2, 2008
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */

class log {

	public $log_path;
	public $_threshold	= 1;
	public $_date_fmt	= 'Y-m-d H:i:s';
	public $_enabled	= TRUE;
	public $_levels	= array('ERROR' => '1', 'DEBUG' => '2',  'INFO' => '3', 'ALL' => '4');

	/**
	 * Constructor
	 *
	 * @access	public
	 * @param	string	the log file path
	 * @param	string	the error threshold
	 * @param	string	the date formatting codes
	 */
	function __construct()
	{
		$config =& get_config();

		$this->log_path = ($config['log_path'] != '') ? $config['log_path'] : dirname(dirname(__FILE__)).'/logs/';

		if ( ! is_dir($this->log_path) OR ! is_writable($this->log_path))
		{
			$this->_enabled = FALSE;
		}
		if (is_numeric($config['log_threshold']))
		{
			$this->_threshold = $config['log_threshold'];
		}

		if ($config['log_date_format'] != '')
		{
			$this->_date_fmt = $config['log_date_format'];
		}
	}

	// --------------------------------------------------------------------

	/**
	 * Write Log File
	 *
	 * Generally this function will be called using the global log_message() function
	 *
	 * @access	public
	 * @param	string	the error level
	 * @param	string	the error message
	 * @param	bool	whether the error is a native PHP error
	 * @return	bool
	 */
	function write_log($level = 'error', $msg, $php_error = FALSE)
	{
		if ($this->_enabled === FALSE)
		{
			return FALSE;
		}

		$level = strtoupper($level);

		if ( ! isset($this->_levels[$level]) OR ($this->_levels[$level] > $this->_threshold))
		{

			return FALSE;
		}

		$filepath = $this->log_path.'log-'.date('Y-m-d').EXT;

		$message  = '';

		if ( ! file_exists($filepath))
		{
			$message .= "<"."?php  if (!defined('BASEPATH')) exit('No direct script access allowed'); ?".">\n\n";
		}

		if ( ! $fp = @fopen($filepath, "a"))
		{
			return FALSE;
		}

		$message .= $level.' '.(($level == 'INFO') ? ' -' : '-').' '.date($this->_date_fmt). ' --> '.$msg."\n";

		flock($fp, LOCK_EX);
		fwrite($fp, $message);
		flock($fp, LOCK_UN);
		fclose($fp);
		@chmod($filepath, 0666);
		return TRUE;
	}

}
// END Log Class
?>
