﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Globalization;

using MvcEnumDropDownList.Infrastructure;
using MvcEnumDropDownList.Models;

namespace MvcEnumDropDownList.Controllers
{
	public class HomeController : Controller
	{
		public ActionResult Index()
		{
			ViewBag.Message = "EnumDropDownList demo";

			var newEvent = new WeeklyEvent() {
				Day = WeekDay.Wednesday,
				AnotherDay = WeekDay.Friday,
				Title = "Demo event"
			};

			return View(newEvent);
		}

		public ActionResult Language(string language)
		{
			SessionHelper.Culture = new CultureInfo(language);

			return RedirectToAction("Index", "Home");
		}
	}
}
