﻿﻿/*
  2  //Software usage License : Blogger Blog intergation into asp.net website
  3  //--------------------------------------------------
  4  //Copyright (c) 7/2012, Suhel Shah (suhel.shah@gmail.com)
  5  //All rights reserved.
  6  
  7  //Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
  8  
  9  //1.  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 10  //2.  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 11  //3.  The name of the Author may not be used to endorse or promote products derived from this software without specific prior written permission.
 12  
 13  //THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
 14  //BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 15  //IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
 16  //OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 17  //PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 18  //OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 19  //POSSIBILITY OF SUCH DAMAGE.
 20  */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;
using Incede.BloggerInteg ;

namespace Incede.blogger.TestProject
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!(IsPostBack))
            {
                lblblogname.Text = "";
                GetBlogEntries();
            }
        }

        public void GetBlogEntries()
        {
            string blogname = ConfigurationSettings.AppSettings["blogName"];
            string userid = ConfigurationSettings.AppSettings["blogUserid"];
            string pwd = ConfigurationSettings.AppSettings["blogPass"];
            string entries = ConfigurationSettings.AppSettings["noOfEntries"];

           Incede.BloggerInteg.BlogService Biservicc = new Incede.BloggerInteg.BlogService(blogname, userid,pwd,int.Parse(entries));

           List<Incede.BloggerInteg.BlogEntry> blogs =   Biservicc.GetUserBlogs();
           ShowBlogEntries(blogs, blogname);
 

        }

        public void ShowBlogEntries(List<Incede.BloggerInteg.BlogEntry> blogitems, string name)
        {
            if ((blogitems != null) & (blogitems.Count > 0))
            {
                
                lblblogname.Text = name;
                this.DataListBlog.DataSource = blogitems;
                this.DataListBlog.DataBind();
            }
            else
            {
                this.DataListBlog.DataSource = null;
                lblblogname.Text = name + " - No blog entries found.";

            }
        }
    }
}
