﻿﻿/*
  2  //Software usage License : Blogger Blog intergation into asp.net website
  3  //--------------------------------------------------
  4  //Copyright (c) 7/2012, Suhel Shah (suhel.shah@gmail.com)
  5  //All rights reserved.
  6  
  7  //Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
  8  
  9  //1.  Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 10  //2.  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 11  //3.  The name of the Author may not be used to endorse or promote products derived from this software without specific prior written permission.
 12  
 13  //THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
 14  //BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 15  //IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
 16  //OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 17  //PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 18  //OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 19  //POSSIBILITY OF SUCH DAMAGE.
 20  */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Google.GData.Blogger;
using Google.GData.Client; 

namespace Incede.BloggerInteg
{
    /// <summary>
    /// This class will provide methods to get the blog entries for a blogger webblog
    /// and present them in a List format.
    /// </summary>
    public class BlogService
    {
        private string username;
        private string password;
        private string blogname;
        private int numberOfEntries;

        /// <summary>
        /// Construnctor
        /// </summary>
        /// <param name="bloggername">name of your blog like (xxxx.blogspot.com)</param>
        /// <param name="blogUser">User id for blog login</param>
        /// <param name="blogPwd">password for blog login</param>
        /// <param name="numberOfBlogtoLoad">number of blog entries to load form your Blogger blog</param>
        public BlogService(string bloggername, string blogUserid, string blogPassword, int numberOfBlogtoLoad)
        {
            blogname = bloggername;
            username = blogUserid;
            password = blogPassword;
            numberOfEntries = numberOfBlogtoLoad;
        }

        public List<BlogEntry> GetUserBlogs()
        {
            if (blogname.Trim().Equals(String.Empty))
                blogname = "incedeit.blogspot.com";//default if not supplied
            if (numberOfEntries <= 0)
                numberOfEntries = 10; //default

            var gService = new Google.GData.Client.Service("blogger", blogname);
            gService.Credentials = new GDataCredentials(username, password);

            Uri blogPostUri = SelectUserBlog(gService, blogname);
            List<BlogEntry> blogs = GetBlogEntryContent(gService, blogPostUri, numberOfEntries);
            return blogs;
            

        }
        static Uri SelectUserBlog(Service service, string blogname)
        {
            //blogname = incedeit.blogspot.com example 
            FeedQuery query = new FeedQuery();
            // Retrieving a list of blogs
            query.Uri = new Uri("http://www.blogger.com/feeds/default/blogs");
            AtomFeed feed = service.Query(query);

            // Publishing a blog post
            Uri blogPostUri = null;
            if (feed != null)
            {
                foreach (AtomEntry entry in feed.Entries)
                {
                    //iterate thru blogs 

                    if (entry.AlternateUri.Content.Contains(blogname))
                    {
                        // find the href in the link with a rel pointing to the blog's feed
                        for (int i = 0; i < entry.Links.Count; i++)
                        {
                            if (entry.Links[i].Rel.Equals("http://schemas.google.com/g/2005#post"))
                            {
                                blogPostUri = new Uri(entry.Links[i].HRef.ToString());
                            }
                        }

                        return blogPostUri;
                    }
                }
            }
            return blogPostUri;
        }

        static List<BlogEntry> GetBlogEntryContent(Service service, Uri blogUri, int numberOfEntries)
        {
            List<BlogEntry> allblogs = new List<BlogEntry>();
            if (blogUri != null)
            {

                // Retrieve all posts in a blog
                FeedQuery query = new FeedQuery();
                query.Uri = blogUri;
                query.NumberToRetrieve = numberOfEntries; //get last x number of posts
                AtomFeed feed = service.Query(query);
                foreach (AtomEntry entry in feed.Entries)
                {
                    BlogEntry b = new BlogEntry();
                    b.Title = entry.Title.Text;
                    b.content = entry.Content.Content;
                    b.footer = String.Format("Posted on {0}", entry.Published.ToString());
                    allblogs.Add(b);
                }
            }
            return allblogs;
        }
    }
}
