﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ProductsDisplaySQL.aspx.cs"
    Inherits="ScrollingSample.ProductsDisplaySQL" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <script src="Scripts/jquery-1.7.2.min.js" type="text/javascript"></script>
    <link href="Styles/Site.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript">
        var pageSize = 20;
        var currentPage = 0;
        var $productstable = null;

        $(document).ready(function () {
            $productstable = $("#productstable");
            AddProducts(pageSize, currentPage);

            $(window).scroll(function () {
                if ($(window).scrollTop() == $(document).height() - $(window).height()) {
                    $('#loader_msg').html('Loading more results......');
                    currentPage = currentPage + 1;
                    AddProducts(pageSize, currentPage);
                }
            });
        });

        function AddProducts(pageSize, currentPage) {

            var url = "api/product/" + pageSize + "/" + currentPage + "/SQL"
            $.ajax({
                url: url,
                contentType: "json",
                success: function (data) {
                    if (data.length > 0) {
                        $.each(data, function (index, item) {
                            var $row = $("#templates").find(".row-template").clone();
                            $row.find(".ProductName").html(item.ProductName);
                            $row.find(".ProductCategory").html(item.CategoryName);
                            $row.find(".SupplierName").html(item.SupplierName);
                            $row.find(".UnitPrice").html(item.UnitPrice);

                            //Change the style for even rows
                            if (index % 2 == 0) {
                                $row.addClass("jtable-row-even")
                            }
                            $productstable.append($row);
                        });
                    }
                    else {
                        $('#loader_msg').html('All Results Loaded......');
                    }
                }
            });
        }
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <h2>
        Load on scroll with LINQ to SQL sample
    </h2>
    <table id="productstable">
        <tr class="row-template">
            <th class="row-column">
                Product Name
            </th>
            <th class="row-column">
                Product Category
            </th>
            <th class="row-column">
                Supplier Name
            </th>
            <th class="row-column">
                Unit Price
            </th>
        </tr>
    </table>
    <div id="loader_msg" style="color:White">
        Loading results......
    </div>
    <div id="templates" style="display: none">
        <table>
            <tr class="row-template">
                <td class="ProductName" style="width: 100px;">
                </td>
                <td class="ProductCategory" style="width: 100px;">
                </td>
                <td class="SupplierName" style="width: 100px;">
                </td>
                <td class="UnitPrice" style="width: 100px;">
                </td>
            </tr>
        </table>
    </div>
    </form>
</body>
</html>
